package zio.aws.cloudhsm
import zio.aws.cloudhsm.model.ListTagsForResourceResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.cloudhsm.model.{
  ListHapgsRequest,
  CreateHapgRequest,
  AddTagsToResourceRequest,
  ListHsmsRequest,
  DescribeHsmRequest,
  ListTagsForResourceRequest,
  ModifyLunaClientRequest,
  ListLunaClientsRequest,
  DeleteHapgRequest,
  ModifyHapgRequest,
  ListAvailableZonesRequest,
  RemoveTagsFromResourceRequest,
  GetConfigRequest,
  DeleteHsmRequest,
  DescribeLunaClientRequest,
  CreateHsmRequest,
  DescribeHapgRequest,
  ModifyHsmRequest,
  DeleteLunaClientRequest,
  CreateLunaClientRequest
}
import zio.aws.core.AwsError
import software.amazon.awssdk.services.cloudhsm.CloudHsmAsyncClient
import zio.aws.core.aspects.AwsCallAspect
import zio.aws.cloudhsm.model.primitives.{ClientArn, HapgArn, HsmArn}
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
object CloudHsmMock extends Mock[CloudHsm] {
  object AddTagsToResource
      extends Effect[
        AddTagsToResourceRequest,
        AwsError,
        zio.aws.cloudhsm.model.AddTagsToResourceResponse.ReadOnly
      ]
  object ListHsms extends Stream[ListHsmsRequest, AwsError, HsmArn]
  object ListHsmsPaginated
      extends Effect[
        ListHsmsRequest,
        AwsError,
        zio.aws.cloudhsm.model.ListHsmsResponse.ReadOnly
      ]
  object CreateHapg
      extends Effect[
        CreateHapgRequest,
        AwsError,
        zio.aws.cloudhsm.model.CreateHapgResponse.ReadOnly
      ]
  object DescribeHapg
      extends Effect[
        DescribeHapgRequest,
        AwsError,
        zio.aws.cloudhsm.model.DescribeHapgResponse.ReadOnly
      ]
  object ModifyLunaClient
      extends Effect[
        ModifyLunaClientRequest,
        AwsError,
        zio.aws.cloudhsm.model.ModifyLunaClientResponse.ReadOnly
      ]
  object RemoveTagsFromResource
      extends Effect[
        RemoveTagsFromResourceRequest,
        AwsError,
        zio.aws.cloudhsm.model.RemoveTagsFromResourceResponse.ReadOnly
      ]
  object ListAvailableZones
      extends Effect[
        ListAvailableZonesRequest,
        AwsError,
        zio.aws.cloudhsm.model.ListAvailableZonesResponse.ReadOnly
      ]
  object CreateLunaClient
      extends Effect[
        CreateLunaClientRequest,
        AwsError,
        zio.aws.cloudhsm.model.CreateLunaClientResponse.ReadOnly
      ]
  object CreateHsm
      extends Effect[
        CreateHsmRequest,
        AwsError,
        zio.aws.cloudhsm.model.CreateHsmResponse.ReadOnly
      ]
  object GetConfig
      extends Effect[
        GetConfigRequest,
        AwsError,
        zio.aws.cloudhsm.model.GetConfigResponse.ReadOnly
      ]
  object ListHapgs extends Stream[ListHapgsRequest, AwsError, HapgArn]
  object ListHapgsPaginated
      extends Effect[
        ListHapgsRequest,
        AwsError,
        zio.aws.cloudhsm.model.ListHapgsResponse.ReadOnly
      ]
  object DescribeLunaClient
      extends Effect[
        DescribeLunaClientRequest,
        AwsError,
        zio.aws.cloudhsm.model.DescribeLunaClientResponse.ReadOnly
      ]
  object DeleteHsm
      extends Effect[
        DeleteHsmRequest,
        AwsError,
        zio.aws.cloudhsm.model.DeleteHsmResponse.ReadOnly
      ]
  object ListLunaClients
      extends Stream[ListLunaClientsRequest, AwsError, ClientArn]
  object ListLunaClientsPaginated
      extends Effect[
        ListLunaClientsRequest,
        AwsError,
        zio.aws.cloudhsm.model.ListLunaClientsResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[ListTagsForResourceRequest, AwsError, ReadOnly]
  object DeleteHapg
      extends Effect[
        DeleteHapgRequest,
        AwsError,
        zio.aws.cloudhsm.model.DeleteHapgResponse.ReadOnly
      ]
  object DeleteLunaClient
      extends Effect[
        DeleteLunaClientRequest,
        AwsError,
        zio.aws.cloudhsm.model.DeleteLunaClientResponse.ReadOnly
      ]
  object DescribeHsm
      extends Effect[
        DescribeHsmRequest,
        AwsError,
        zio.aws.cloudhsm.model.DescribeHsmResponse.ReadOnly
      ]
  object ModifyHapg
      extends Effect[
        ModifyHapgRequest,
        AwsError,
        zio.aws.cloudhsm.model.ModifyHapgResponse.ReadOnly
      ]
  object ModifyHsm
      extends Effect[
        ModifyHsmRequest,
        AwsError,
        zio.aws.cloudhsm.model.ModifyHsmResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, CloudHsm] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, CloudHsm] { rts =>
        zio.ZIO.succeed {
          new CloudHsm {
            val api: CloudHsmAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): CloudHsm = this
            def addTagsToResource(request: AddTagsToResourceRequest): IO[
              AwsError,
              zio.aws.cloudhsm.model.AddTagsToResourceResponse.ReadOnly
            ] = proxy(AddTagsToResource, request)
            def listHsms(
                request: ListHsmsRequest
            ): ZStream[Any, AwsError, HsmArn] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListHsms, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listHsmsPaginated(
                request: ListHsmsRequest
            ): IO[AwsError, zio.aws.cloudhsm.model.ListHsmsResponse.ReadOnly] =
              proxy(ListHsmsPaginated, request)
            def createHapg(request: CreateHapgRequest): IO[
              AwsError,
              zio.aws.cloudhsm.model.CreateHapgResponse.ReadOnly
            ] = proxy(CreateHapg, request)
            def describeHapg(request: DescribeHapgRequest): IO[
              AwsError,
              zio.aws.cloudhsm.model.DescribeHapgResponse.ReadOnly
            ] = proxy(DescribeHapg, request)
            def modifyLunaClient(request: ModifyLunaClientRequest): IO[
              AwsError,
              zio.aws.cloudhsm.model.ModifyLunaClientResponse.ReadOnly
            ] = proxy(ModifyLunaClient, request)
            def removeTagsFromResource(
                request: RemoveTagsFromResourceRequest
            ): IO[
              AwsError,
              zio.aws.cloudhsm.model.RemoveTagsFromResourceResponse.ReadOnly
            ] = proxy(RemoveTagsFromResource, request)
            def listAvailableZones(request: ListAvailableZonesRequest): IO[
              AwsError,
              zio.aws.cloudhsm.model.ListAvailableZonesResponse.ReadOnly
            ] = proxy(ListAvailableZones, request)
            def createLunaClient(request: CreateLunaClientRequest): IO[
              AwsError,
              zio.aws.cloudhsm.model.CreateLunaClientResponse.ReadOnly
            ] = proxy(CreateLunaClient, request)
            def createHsm(
                request: CreateHsmRequest
            ): IO[AwsError, zio.aws.cloudhsm.model.CreateHsmResponse.ReadOnly] =
              proxy(CreateHsm, request)
            def getConfig(
                request: GetConfigRequest
            ): IO[AwsError, zio.aws.cloudhsm.model.GetConfigResponse.ReadOnly] =
              proxy(GetConfig, request)
            def listHapgs(
                request: ListHapgsRequest
            ): ZStream[Any, AwsError, HapgArn] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListHapgs, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listHapgsPaginated(
                request: ListHapgsRequest
            ): IO[AwsError, zio.aws.cloudhsm.model.ListHapgsResponse.ReadOnly] =
              proxy(ListHapgsPaginated, request)
            def describeLunaClient(request: DescribeLunaClientRequest): IO[
              AwsError,
              zio.aws.cloudhsm.model.DescribeLunaClientResponse.ReadOnly
            ] = proxy(DescribeLunaClient, request)
            def deleteHsm(
                request: DeleteHsmRequest
            ): IO[AwsError, zio.aws.cloudhsm.model.DeleteHsmResponse.ReadOnly] =
              proxy(DeleteHsm, request)
            def listLunaClients(
                request: ListLunaClientsRequest
            ): ZStream[Any, AwsError, ClientArn] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListLunaClients, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listLunaClientsPaginated(request: ListLunaClientsRequest): IO[
              AwsError,
              zio.aws.cloudhsm.model.ListLunaClientsResponse.ReadOnly
            ] = proxy(ListLunaClientsPaginated, request)
            def listTagsForResource(
                request: ListTagsForResourceRequest
            ): IO[AwsError, ReadOnly] = proxy(ListTagsForResource, request)
            def deleteHapg(request: DeleteHapgRequest): IO[
              AwsError,
              zio.aws.cloudhsm.model.DeleteHapgResponse.ReadOnly
            ] = proxy(DeleteHapg, request)
            def deleteLunaClient(request: DeleteLunaClientRequest): IO[
              AwsError,
              zio.aws.cloudhsm.model.DeleteLunaClientResponse.ReadOnly
            ] = proxy(DeleteLunaClient, request)
            def describeHsm(request: DescribeHsmRequest): IO[
              AwsError,
              zio.aws.cloudhsm.model.DescribeHsmResponse.ReadOnly
            ] = proxy(DescribeHsm, request)
            def modifyHapg(request: ModifyHapgRequest): IO[
              AwsError,
              zio.aws.cloudhsm.model.ModifyHapgResponse.ReadOnly
            ] = proxy(ModifyHapg, request)
            def modifyHsm(
                request: ModifyHsmRequest
            ): IO[AwsError, zio.aws.cloudhsm.model.ModifyHsmResponse.ReadOnly] =
              proxy(ModifyHsm, request)
          }
        }
      }
    }
  }
}
