package zio.aws.cloudhsm.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AddTagsToResourceRequest(
    resourceArn: String,
    tagList: Iterable[zio.aws.cloudhsm.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudhsm.model.AddTagsToResourceRequest = {
    import AddTagsToResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudhsm.model.AddTagsToResourceRequest
      .builder()
      .resourceArn(resourceArn: java.lang.String)
      .tagList(tagList.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.cloudhsm.model.AddTagsToResourceRequest.ReadOnly =
    zio.aws.cloudhsm.model.AddTagsToResourceRequest.wrap(buildAwsValue())
}
object AddTagsToResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudhsm.model.AddTagsToResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudhsm.model.AddTagsToResourceRequest =
      zio.aws.cloudhsm.model.AddTagsToResourceRequest(
        resourceArn,
        tagList.map { item =>
          item.asEditable
        }
      )
    def resourceArn: String
    def tagList: List[zio.aws.cloudhsm.model.Tag.ReadOnly]
    def getResourceArn: ZIO[Any, Nothing, String] = ZIO.succeed(resourceArn)
    def getTagList
        : ZIO[Any, Nothing, List[zio.aws.cloudhsm.model.Tag.ReadOnly]] =
      ZIO.succeed(tagList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudhsm.model.AddTagsToResourceRequest
  ) extends zio.aws.cloudhsm.model.AddTagsToResourceRequest.ReadOnly {
    override val resourceArn: String = impl.resourceArn(): String
    override val tagList: List[zio.aws.cloudhsm.model.Tag.ReadOnly] = impl
      .tagList()
      .asScala
      .map { item =>
        zio.aws.cloudhsm.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudhsm.model.AddTagsToResourceRequest
  ): zio.aws.cloudhsm.model.AddTagsToResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
