package zio.aws.cloudhsm.model
import scala.jdk.CollectionConverters._
sealed trait CloudHsmObjectState {
  def unwrap: software.amazon.awssdk.services.cloudhsm.model.CloudHsmObjectState
}
object CloudHsmObjectState {
  def wrap(
      value: software.amazon.awssdk.services.cloudhsm.model.CloudHsmObjectState
  ): zio.aws.cloudhsm.model.CloudHsmObjectState = value match {
    case software.amazon.awssdk.services.cloudhsm.model.CloudHsmObjectState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudhsm.model.CloudHsmObjectState.READY =>
      val r = READY
      r
    case software.amazon.awssdk.services.cloudhsm.model.CloudHsmObjectState.UPDATING =>
      val r = UPDATING
      r
    case software.amazon.awssdk.services.cloudhsm.model.CloudHsmObjectState.DEGRADED =>
      val r = DEGRADED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudhsm.model.CloudHsmObjectState {
    override def unwrap
        : software.amazon.awssdk.services.cloudhsm.model.CloudHsmObjectState =
      software.amazon.awssdk.services.cloudhsm.model.CloudHsmObjectState.UNKNOWN_TO_SDK_VERSION
  }
  case object READY extends zio.aws.cloudhsm.model.CloudHsmObjectState {
    override def unwrap
        : software.amazon.awssdk.services.cloudhsm.model.CloudHsmObjectState =
      software.amazon.awssdk.services.cloudhsm.model.CloudHsmObjectState.READY
  }
  case object UPDATING extends zio.aws.cloudhsm.model.CloudHsmObjectState {
    override def unwrap
        : software.amazon.awssdk.services.cloudhsm.model.CloudHsmObjectState =
      software.amazon.awssdk.services.cloudhsm.model.CloudHsmObjectState.UPDATING
  }
  case object DEGRADED extends zio.aws.cloudhsm.model.CloudHsmObjectState {
    override def unwrap
        : software.amazon.awssdk.services.cloudhsm.model.CloudHsmObjectState =
      software.amazon.awssdk.services.cloudhsm.model.CloudHsmObjectState.DEGRADED
  }
}
