package zio.aws.cloudhsm.model
import zio.ZIO
import zio.aws.cloudhsm.model.primitives.{
  SubnetId,
  IamRoleArn,
  SshKey,
  IpAddress,
  ClientToken,
  ExternalId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateHsmRequest(
    subnetId: SubnetId,
    sshKey: SshKey,
    eniIp: Optional[IpAddress] = Optional.Absent,
    iamRoleArn: IamRoleArn,
    externalId: Optional[ExternalId] = Optional.Absent,
    subscriptionType: zio.aws.cloudhsm.model.SubscriptionType,
    clientToken: Optional[ClientToken] = Optional.Absent,
    syslogIp: Optional[IpAddress] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudhsm.model.CreateHsmRequest = {
    import CreateHsmRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudhsm.model.CreateHsmRequest
      .builder()
      .subnetId(SubnetId.unwrap(subnetId): java.lang.String)
      .sshKey(SshKey.unwrap(sshKey): java.lang.String)
      .optionallyWith(
        eniIp.map(value => IpAddress.unwrap(value): java.lang.String)
      )(_.eniIp)
      .iamRoleArn(IamRoleArn.unwrap(iamRoleArn): java.lang.String)
      .optionallyWith(
        externalId.map(value => ExternalId.unwrap(value): java.lang.String)
      )(_.externalId)
      .subscriptionType(subscriptionType.unwrap)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        syslogIp.map(value => IpAddress.unwrap(value): java.lang.String)
      )(_.syslogIp)
      .build()
  }
  def asReadOnly: zio.aws.cloudhsm.model.CreateHsmRequest.ReadOnly =
    zio.aws.cloudhsm.model.CreateHsmRequest.wrap(buildAwsValue())
}
object CreateHsmRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudhsm.model.CreateHsmRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudhsm.model.CreateHsmRequest =
      zio.aws.cloudhsm.model.CreateHsmRequest(
        subnetId,
        sshKey,
        eniIp.map(value => value),
        iamRoleArn,
        externalId.map(value => value),
        subscriptionType,
        clientToken.map(value => value),
        syslogIp.map(value => value)
      )
    def subnetId: SubnetId
    def sshKey: SshKey
    def eniIp: Optional[IpAddress]
    def iamRoleArn: IamRoleArn
    def externalId: Optional[ExternalId]
    def subscriptionType: zio.aws.cloudhsm.model.SubscriptionType
    def clientToken: Optional[ClientToken]
    def syslogIp: Optional[IpAddress]
    def getSubnetId: ZIO[Any, Nothing, SubnetId] = ZIO.succeed(subnetId)
    def getSshKey: ZIO[Any, Nothing, SshKey] = ZIO.succeed(sshKey)
    def getEniIp: ZIO[Any, AwsError, IpAddress] =
      AwsError.unwrapOptionField("eniIp", eniIp)
    def getIamRoleArn: ZIO[Any, Nothing, IamRoleArn] = ZIO.succeed(iamRoleArn)
    def getExternalId: ZIO[Any, AwsError, ExternalId] =
      AwsError.unwrapOptionField("externalId", externalId)
    def getSubscriptionType
        : ZIO[Any, Nothing, zio.aws.cloudhsm.model.SubscriptionType] =
      ZIO.succeed(subscriptionType)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getSyslogIp: ZIO[Any, AwsError, IpAddress] =
      AwsError.unwrapOptionField("syslogIp", syslogIp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudhsm.model.CreateHsmRequest
  ) extends zio.aws.cloudhsm.model.CreateHsmRequest.ReadOnly {
    override val subnetId: SubnetId =
      zio.aws.cloudhsm.model.primitives.SubnetId(impl.subnetId())
    override val sshKey: SshKey =
      zio.aws.cloudhsm.model.primitives.SshKey(impl.sshKey())
    override val eniIp: Optional[IpAddress] = zio.aws.core.internal
      .optionalFromNullable(impl.eniIp())
      .map(value => zio.aws.cloudhsm.model.primitives.IpAddress(value))
    override val iamRoleArn: IamRoleArn =
      zio.aws.cloudhsm.model.primitives.IamRoleArn(impl.iamRoleArn())
    override val externalId: Optional[ExternalId] = zio.aws.core.internal
      .optionalFromNullable(impl.externalId())
      .map(value => zio.aws.cloudhsm.model.primitives.ExternalId(value))
    override val subscriptionType: zio.aws.cloudhsm.model.SubscriptionType =
      zio.aws.cloudhsm.model.SubscriptionType.wrap(impl.subscriptionType())
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.cloudhsm.model.primitives.ClientToken(value))
    override val syslogIp: Optional[IpAddress] = zio.aws.core.internal
      .optionalFromNullable(impl.syslogIp())
      .map(value => zio.aws.cloudhsm.model.primitives.IpAddress(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudhsm.model.CreateHsmRequest
  ): zio.aws.cloudhsm.model.CreateHsmRequest.ReadOnly = new Wrapper(impl)
}
