package zio.aws.cloudhsm.model
import zio.ZIO
import zio.aws.cloudhsm.model.primitives.{
  Timestamp,
  Label,
  HapgArn,
  PartitionSerial,
  HsmArn
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeHapgResponse(
    hapgArn: Optional[HapgArn] = Optional.Absent,
    hapgSerial: Optional[String] = Optional.Absent,
    hsmsLastActionFailed: Optional[Iterable[HsmArn]] = Optional.Absent,
    hsmsPendingDeletion: Optional[Iterable[HsmArn]] = Optional.Absent,
    hsmsPendingRegistration: Optional[Iterable[HsmArn]] = Optional.Absent,
    label: Optional[Label] = Optional.Absent,
    lastModifiedTimestamp: Optional[Timestamp] = Optional.Absent,
    partitionSerialList: Optional[Iterable[PartitionSerial]] = Optional.Absent,
    state: Optional[zio.aws.cloudhsm.model.CloudHsmObjectState] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudhsm.model.DescribeHapgResponse = {
    import DescribeHapgResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudhsm.model.DescribeHapgResponse
      .builder()
      .optionallyWith(
        hapgArn.map(value => HapgArn.unwrap(value): java.lang.String)
      )(_.hapgArn)
      .optionallyWith(hapgSerial.map(value => value: java.lang.String))(
        _.hapgSerial
      )
      .optionallyWith(
        hsmsLastActionFailed.map(value =>
          value.map { item =>
            HsmArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.hsmsLastActionFailed)
      .optionallyWith(
        hsmsPendingDeletion.map(value =>
          value.map { item =>
            HsmArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.hsmsPendingDeletion)
      .optionallyWith(
        hsmsPendingRegistration.map(value =>
          value.map { item =>
            HsmArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.hsmsPendingRegistration)
      .optionallyWith(
        label.map(value => Label.unwrap(value): java.lang.String)
      )(_.label)
      .optionallyWith(
        lastModifiedTimestamp.map(value =>
          Timestamp.unwrap(value): java.lang.String
        )
      )(_.lastModifiedTimestamp)
      .optionallyWith(
        partitionSerialList.map(value =>
          value.map { item =>
            PartitionSerial.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.partitionSerialList)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .build()
  }
  def asReadOnly: zio.aws.cloudhsm.model.DescribeHapgResponse.ReadOnly =
    zio.aws.cloudhsm.model.DescribeHapgResponse.wrap(buildAwsValue())
}
object DescribeHapgResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudhsm.model.DescribeHapgResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudhsm.model.DescribeHapgResponse =
      zio.aws.cloudhsm.model.DescribeHapgResponse(
        hapgArn.map(value => value),
        hapgSerial.map(value => value),
        hsmsLastActionFailed.map(value => value),
        hsmsPendingDeletion.map(value => value),
        hsmsPendingRegistration.map(value => value),
        label.map(value => value),
        lastModifiedTimestamp.map(value => value),
        partitionSerialList.map(value => value),
        state.map(value => value)
      )
    def hapgArn: Optional[HapgArn]
    def hapgSerial: Optional[String]
    def hsmsLastActionFailed: Optional[List[HsmArn]]
    def hsmsPendingDeletion: Optional[List[HsmArn]]
    def hsmsPendingRegistration: Optional[List[HsmArn]]
    def label: Optional[Label]
    def lastModifiedTimestamp: Optional[Timestamp]
    def partitionSerialList: Optional[List[PartitionSerial]]
    def state: Optional[zio.aws.cloudhsm.model.CloudHsmObjectState]
    def getHapgArn: ZIO[Any, AwsError, HapgArn] =
      AwsError.unwrapOptionField("hapgArn", hapgArn)
    def getHapgSerial: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("hapgSerial", hapgSerial)
    def getHsmsLastActionFailed: ZIO[Any, AwsError, List[HsmArn]] =
      AwsError.unwrapOptionField("hsmsLastActionFailed", hsmsLastActionFailed)
    def getHsmsPendingDeletion: ZIO[Any, AwsError, List[HsmArn]] =
      AwsError.unwrapOptionField("hsmsPendingDeletion", hsmsPendingDeletion)
    def getHsmsPendingRegistration: ZIO[Any, AwsError, List[HsmArn]] = AwsError
      .unwrapOptionField("hsmsPendingRegistration", hsmsPendingRegistration)
    def getLabel: ZIO[Any, AwsError, Label] =
      AwsError.unwrapOptionField("label", label)
    def getLastModifiedTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTimestamp", lastModifiedTimestamp)
    def getPartitionSerialList: ZIO[Any, AwsError, List[PartitionSerial]] =
      AwsError.unwrapOptionField("partitionSerialList", partitionSerialList)
    def getState
        : ZIO[Any, AwsError, zio.aws.cloudhsm.model.CloudHsmObjectState] =
      AwsError.unwrapOptionField("state", state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudhsm.model.DescribeHapgResponse
  ) extends zio.aws.cloudhsm.model.DescribeHapgResponse.ReadOnly {
    override val hapgArn: Optional[HapgArn] = zio.aws.core.internal
      .optionalFromNullable(impl.hapgArn())
      .map(value => zio.aws.cloudhsm.model.primitives.HapgArn(value))
    override val hapgSerial: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.hapgSerial())
      .map(value => value: String)
    override val hsmsLastActionFailed: Optional[List[HsmArn]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hsmsLastActionFailed())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudhsm.model.primitives.HsmArn(item)
          }.toList
        )
    override val hsmsPendingDeletion: Optional[List[HsmArn]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hsmsPendingDeletion())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudhsm.model.primitives.HsmArn(item)
          }.toList
        )
    override val hsmsPendingRegistration: Optional[List[HsmArn]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hsmsPendingRegistration())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudhsm.model.primitives.HsmArn(item)
          }.toList
        )
    override val label: Optional[Label] = zio.aws.core.internal
      .optionalFromNullable(impl.label())
      .map(value => zio.aws.cloudhsm.model.primitives.Label(value))
    override val lastModifiedTimestamp: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModifiedTimestamp())
        .map(value => zio.aws.cloudhsm.model.primitives.Timestamp(value))
    override val partitionSerialList: Optional[List[PartitionSerial]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.partitionSerialList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudhsm.model.primitives.PartitionSerial(item)
          }.toList
        )
    override val state: Optional[zio.aws.cloudhsm.model.CloudHsmObjectState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.cloudhsm.model.CloudHsmObjectState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudhsm.model.DescribeHapgResponse
  ): zio.aws.cloudhsm.model.DescribeHapgResponse.ReadOnly = new Wrapper(impl)
}
