package zio.aws.cloudhsm.model
import zio.ZIO
import zio.aws.cloudhsm.model.primitives.{
  SubnetId,
  VpcId,
  IamRoleArn,
  Timestamp,
  SshKey,
  IpAddress,
  HsmArn,
  AZ,
  PartitionArn,
  EniId,
  HsmSerialNumber
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeHsmResponse(
    hsmArn: Optional[HsmArn] = Optional.Absent,
    status: Optional[zio.aws.cloudhsm.model.HsmStatus] = Optional.Absent,
    statusDetails: Optional[String] = Optional.Absent,
    availabilityZone: Optional[AZ] = Optional.Absent,
    eniId: Optional[EniId] = Optional.Absent,
    eniIp: Optional[IpAddress] = Optional.Absent,
    subscriptionType: Optional[zio.aws.cloudhsm.model.SubscriptionType] =
      Optional.Absent,
    subscriptionStartDate: Optional[Timestamp] = Optional.Absent,
    subscriptionEndDate: Optional[Timestamp] = Optional.Absent,
    vpcId: Optional[VpcId] = Optional.Absent,
    subnetId: Optional[SubnetId] = Optional.Absent,
    iamRoleArn: Optional[IamRoleArn] = Optional.Absent,
    serialNumber: Optional[HsmSerialNumber] = Optional.Absent,
    vendorName: Optional[String] = Optional.Absent,
    hsmType: Optional[String] = Optional.Absent,
    softwareVersion: Optional[String] = Optional.Absent,
    sshPublicKey: Optional[SshKey] = Optional.Absent,
    sshKeyLastUpdated: Optional[Timestamp] = Optional.Absent,
    serverCertUri: Optional[String] = Optional.Absent,
    serverCertLastUpdated: Optional[Timestamp] = Optional.Absent,
    partitions: Optional[Iterable[PartitionArn]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudhsm.model.DescribeHsmResponse = {
    import DescribeHsmResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudhsm.model.DescribeHsmResponse
      .builder()
      .optionallyWith(
        hsmArn.map(value => HsmArn.unwrap(value): java.lang.String)
      )(_.hsmArn)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(statusDetails.map(value => value: java.lang.String))(
        _.statusDetails
      )
      .optionallyWith(
        availabilityZone.map(value => AZ.unwrap(value): java.lang.String)
      )(_.availabilityZone)
      .optionallyWith(
        eniId.map(value => EniId.unwrap(value): java.lang.String)
      )(_.eniId)
      .optionallyWith(
        eniIp.map(value => IpAddress.unwrap(value): java.lang.String)
      )(_.eniIp)
      .optionallyWith(subscriptionType.map(value => value.unwrap))(
        _.subscriptionType
      )
      .optionallyWith(
        subscriptionStartDate.map(value =>
          Timestamp.unwrap(value): java.lang.String
        )
      )(_.subscriptionStartDate)
      .optionallyWith(
        subscriptionEndDate.map(value =>
          Timestamp.unwrap(value): java.lang.String
        )
      )(_.subscriptionEndDate)
      .optionallyWith(
        vpcId.map(value => VpcId.unwrap(value): java.lang.String)
      )(_.vpcId)
      .optionallyWith(
        subnetId.map(value => SubnetId.unwrap(value): java.lang.String)
      )(_.subnetId)
      .optionallyWith(
        iamRoleArn.map(value => IamRoleArn.unwrap(value): java.lang.String)
      )(_.iamRoleArn)
      .optionallyWith(
        serialNumber.map(value =>
          HsmSerialNumber.unwrap(value): java.lang.String
        )
      )(_.serialNumber)
      .optionallyWith(vendorName.map(value => value: java.lang.String))(
        _.vendorName
      )
      .optionallyWith(hsmType.map(value => value: java.lang.String))(_.hsmType)
      .optionallyWith(softwareVersion.map(value => value: java.lang.String))(
        _.softwareVersion
      )
      .optionallyWith(
        sshPublicKey.map(value => SshKey.unwrap(value): java.lang.String)
      )(_.sshPublicKey)
      .optionallyWith(
        sshKeyLastUpdated.map(value =>
          Timestamp.unwrap(value): java.lang.String
        )
      )(_.sshKeyLastUpdated)
      .optionallyWith(serverCertUri.map(value => value: java.lang.String))(
        _.serverCertUri
      )
      .optionallyWith(
        serverCertLastUpdated.map(value =>
          Timestamp.unwrap(value): java.lang.String
        )
      )(_.serverCertLastUpdated)
      .optionallyWith(
        partitions.map(value =>
          value.map { item =>
            PartitionArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.partitions)
      .build()
  }
  def asReadOnly: zio.aws.cloudhsm.model.DescribeHsmResponse.ReadOnly =
    zio.aws.cloudhsm.model.DescribeHsmResponse.wrap(buildAwsValue())
}
object DescribeHsmResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudhsm.model.DescribeHsmResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudhsm.model.DescribeHsmResponse =
      zio.aws.cloudhsm.model.DescribeHsmResponse(
        hsmArn.map(value => value),
        status.map(value => value),
        statusDetails.map(value => value),
        availabilityZone.map(value => value),
        eniId.map(value => value),
        eniIp.map(value => value),
        subscriptionType.map(value => value),
        subscriptionStartDate.map(value => value),
        subscriptionEndDate.map(value => value),
        vpcId.map(value => value),
        subnetId.map(value => value),
        iamRoleArn.map(value => value),
        serialNumber.map(value => value),
        vendorName.map(value => value),
        hsmType.map(value => value),
        softwareVersion.map(value => value),
        sshPublicKey.map(value => value),
        sshKeyLastUpdated.map(value => value),
        serverCertUri.map(value => value),
        serverCertLastUpdated.map(value => value),
        partitions.map(value => value)
      )
    def hsmArn: Optional[HsmArn]
    def status: Optional[zio.aws.cloudhsm.model.HsmStatus]
    def statusDetails: Optional[String]
    def availabilityZone: Optional[AZ]
    def eniId: Optional[EniId]
    def eniIp: Optional[IpAddress]
    def subscriptionType: Optional[zio.aws.cloudhsm.model.SubscriptionType]
    def subscriptionStartDate: Optional[Timestamp]
    def subscriptionEndDate: Optional[Timestamp]
    def vpcId: Optional[VpcId]
    def subnetId: Optional[SubnetId]
    def iamRoleArn: Optional[IamRoleArn]
    def serialNumber: Optional[HsmSerialNumber]
    def vendorName: Optional[String]
    def hsmType: Optional[String]
    def softwareVersion: Optional[String]
    def sshPublicKey: Optional[SshKey]
    def sshKeyLastUpdated: Optional[Timestamp]
    def serverCertUri: Optional[String]
    def serverCertLastUpdated: Optional[Timestamp]
    def partitions: Optional[List[PartitionArn]]
    def getHsmArn: ZIO[Any, AwsError, HsmArn] =
      AwsError.unwrapOptionField("hsmArn", hsmArn)
    def getStatus: ZIO[Any, AwsError, zio.aws.cloudhsm.model.HsmStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusDetails: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusDetails", statusDetails)
    def getAvailabilityZone: ZIO[Any, AwsError, AZ] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getEniId: ZIO[Any, AwsError, EniId] =
      AwsError.unwrapOptionField("eniId", eniId)
    def getEniIp: ZIO[Any, AwsError, IpAddress] =
      AwsError.unwrapOptionField("eniIp", eniIp)
    def getSubscriptionType
        : ZIO[Any, AwsError, zio.aws.cloudhsm.model.SubscriptionType] =
      AwsError.unwrapOptionField("subscriptionType", subscriptionType)
    def getSubscriptionStartDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("subscriptionStartDate", subscriptionStartDate)
    def getSubscriptionEndDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("subscriptionEndDate", subscriptionEndDate)
    def getVpcId: ZIO[Any, AwsError, VpcId] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getSubnetId: ZIO[Any, AwsError, SubnetId] =
      AwsError.unwrapOptionField("subnetId", subnetId)
    def getIamRoleArn: ZIO[Any, AwsError, IamRoleArn] =
      AwsError.unwrapOptionField("iamRoleArn", iamRoleArn)
    def getSerialNumber: ZIO[Any, AwsError, HsmSerialNumber] =
      AwsError.unwrapOptionField("serialNumber", serialNumber)
    def getVendorName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vendorName", vendorName)
    def getHsmType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("hsmType", hsmType)
    def getSoftwareVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("softwareVersion", softwareVersion)
    def getSshPublicKey: ZIO[Any, AwsError, SshKey] =
      AwsError.unwrapOptionField("sshPublicKey", sshPublicKey)
    def getSshKeyLastUpdated: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("sshKeyLastUpdated", sshKeyLastUpdated)
    def getServerCertUri: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serverCertUri", serverCertUri)
    def getServerCertLastUpdated: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("serverCertLastUpdated", serverCertLastUpdated)
    def getPartitions: ZIO[Any, AwsError, List[PartitionArn]] =
      AwsError.unwrapOptionField("partitions", partitions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudhsm.model.DescribeHsmResponse
  ) extends zio.aws.cloudhsm.model.DescribeHsmResponse.ReadOnly {
    override val hsmArn: Optional[HsmArn] = zio.aws.core.internal
      .optionalFromNullable(impl.hsmArn())
      .map(value => zio.aws.cloudhsm.model.primitives.HsmArn(value))
    override val status: Optional[zio.aws.cloudhsm.model.HsmStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.cloudhsm.model.HsmStatus.wrap(value))
    override val statusDetails: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.statusDetails())
      .map(value => value: String)
    override val availabilityZone: Optional[AZ] = zio.aws.core.internal
      .optionalFromNullable(impl.availabilityZone())
      .map(value => zio.aws.cloudhsm.model.primitives.AZ(value))
    override val eniId: Optional[EniId] = zio.aws.core.internal
      .optionalFromNullable(impl.eniId())
      .map(value => zio.aws.cloudhsm.model.primitives.EniId(value))
    override val eniIp: Optional[IpAddress] = zio.aws.core.internal
      .optionalFromNullable(impl.eniIp())
      .map(value => zio.aws.cloudhsm.model.primitives.IpAddress(value))
    override val subscriptionType
        : Optional[zio.aws.cloudhsm.model.SubscriptionType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subscriptionType())
        .map(value => zio.aws.cloudhsm.model.SubscriptionType.wrap(value))
    override val subscriptionStartDate: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subscriptionStartDate())
        .map(value => zio.aws.cloudhsm.model.primitives.Timestamp(value))
    override val subscriptionEndDate: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subscriptionEndDate())
        .map(value => zio.aws.cloudhsm.model.primitives.Timestamp(value))
    override val vpcId: Optional[VpcId] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => zio.aws.cloudhsm.model.primitives.VpcId(value))
    override val subnetId: Optional[SubnetId] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetId())
      .map(value => zio.aws.cloudhsm.model.primitives.SubnetId(value))
    override val iamRoleArn: Optional[IamRoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.iamRoleArn())
      .map(value => zio.aws.cloudhsm.model.primitives.IamRoleArn(value))
    override val serialNumber: Optional[HsmSerialNumber] = zio.aws.core.internal
      .optionalFromNullable(impl.serialNumber())
      .map(value => zio.aws.cloudhsm.model.primitives.HsmSerialNumber(value))
    override val vendorName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.vendorName())
      .map(value => value: String)
    override val hsmType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.hsmType())
      .map(value => value: String)
    override val softwareVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.softwareVersion())
      .map(value => value: String)
    override val sshPublicKey: Optional[SshKey] = zio.aws.core.internal
      .optionalFromNullable(impl.sshPublicKey())
      .map(value => zio.aws.cloudhsm.model.primitives.SshKey(value))
    override val sshKeyLastUpdated: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.sshKeyLastUpdated())
      .map(value => zio.aws.cloudhsm.model.primitives.Timestamp(value))
    override val serverCertUri: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.serverCertUri())
      .map(value => value: String)
    override val serverCertLastUpdated: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serverCertLastUpdated())
        .map(value => zio.aws.cloudhsm.model.primitives.Timestamp(value))
    override val partitions: Optional[List[PartitionArn]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.partitions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudhsm.model.primitives.PartitionArn(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudhsm.model.DescribeHsmResponse
  ): zio.aws.cloudhsm.model.DescribeHsmResponse.ReadOnly = new Wrapper(impl)
}
