package zio.aws.cloudhsm.model
import zio.ZIO
import zio.aws.cloudhsm.model.primitives.{CertificateFingerprint, ClientArn}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeLunaClientRequest(
    clientArn: Optional[ClientArn] = Optional.Absent,
    certificateFingerprint: Optional[CertificateFingerprint] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudhsm.model.DescribeLunaClientRequest = {
    import DescribeLunaClientRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudhsm.model.DescribeLunaClientRequest
      .builder()
      .optionallyWith(
        clientArn.map(value => ClientArn.unwrap(value): java.lang.String)
      )(_.clientArn)
      .optionallyWith(
        certificateFingerprint.map(value =>
          CertificateFingerprint.unwrap(value): java.lang.String
        )
      )(_.certificateFingerprint)
      .build()
  }
  def asReadOnly: zio.aws.cloudhsm.model.DescribeLunaClientRequest.ReadOnly =
    zio.aws.cloudhsm.model.DescribeLunaClientRequest.wrap(buildAwsValue())
}
object DescribeLunaClientRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudhsm.model.DescribeLunaClientRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudhsm.model.DescribeLunaClientRequest =
      zio.aws.cloudhsm.model.DescribeLunaClientRequest(
        clientArn.map(value => value),
        certificateFingerprint.map(value => value)
      )
    def clientArn: Optional[ClientArn]
    def certificateFingerprint: Optional[CertificateFingerprint]
    def getClientArn: ZIO[Any, AwsError, ClientArn] =
      AwsError.unwrapOptionField("clientArn", clientArn)
    def getCertificateFingerprint: ZIO[Any, AwsError, CertificateFingerprint] =
      AwsError.unwrapOptionField(
        "certificateFingerprint",
        certificateFingerprint
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudhsm.model.DescribeLunaClientRequest
  ) extends zio.aws.cloudhsm.model.DescribeLunaClientRequest.ReadOnly {
    override val clientArn: Optional[ClientArn] = zio.aws.core.internal
      .optionalFromNullable(impl.clientArn())
      .map(value => zio.aws.cloudhsm.model.primitives.ClientArn(value))
    override val certificateFingerprint: Optional[CertificateFingerprint] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certificateFingerprint())
        .map(value =>
          zio.aws.cloudhsm.model.primitives.CertificateFingerprint(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudhsm.model.DescribeLunaClientRequest
  ): zio.aws.cloudhsm.model.DescribeLunaClientRequest.ReadOnly = new Wrapper(
    impl
  )
}
