package zio.aws.cloudhsm.model
import scala.jdk.CollectionConverters._
sealed trait HsmStatus {
  def unwrap: software.amazon.awssdk.services.cloudhsm.model.HsmStatus
}
object HsmStatus {
  def wrap(
      value: software.amazon.awssdk.services.cloudhsm.model.HsmStatus
  ): zio.aws.cloudhsm.model.HsmStatus = value match {
    case software.amazon.awssdk.services.cloudhsm.model.HsmStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudhsm.model.HsmStatus.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.cloudhsm.model.HsmStatus.RUNNING =>
      val r = RUNNING
      r
    case software.amazon.awssdk.services.cloudhsm.model.HsmStatus.UPDATING =>
      val r = UPDATING
      r
    case software.amazon.awssdk.services.cloudhsm.model.HsmStatus.SUSPENDED =>
      val r = SUSPENDED
      r
    case software.amazon.awssdk.services.cloudhsm.model.HsmStatus.TERMINATING =>
      val r = TERMINATING
      r
    case software.amazon.awssdk.services.cloudhsm.model.HsmStatus.TERMINATED =>
      val r = TERMINATED
      r
    case software.amazon.awssdk.services.cloudhsm.model.HsmStatus.DEGRADED =>
      val r = DEGRADED
      r
  }
  case object unknownToSdkVersion extends zio.aws.cloudhsm.model.HsmStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudhsm.model.HsmStatus =
      software.amazon.awssdk.services.cloudhsm.model.HsmStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING extends zio.aws.cloudhsm.model.HsmStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudhsm.model.HsmStatus =
      software.amazon.awssdk.services.cloudhsm.model.HsmStatus.PENDING
  }
  case object RUNNING extends zio.aws.cloudhsm.model.HsmStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudhsm.model.HsmStatus =
      software.amazon.awssdk.services.cloudhsm.model.HsmStatus.RUNNING
  }
  case object UPDATING extends zio.aws.cloudhsm.model.HsmStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudhsm.model.HsmStatus =
      software.amazon.awssdk.services.cloudhsm.model.HsmStatus.UPDATING
  }
  case object SUSPENDED extends zio.aws.cloudhsm.model.HsmStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudhsm.model.HsmStatus =
      software.amazon.awssdk.services.cloudhsm.model.HsmStatus.SUSPENDED
  }
  case object TERMINATING extends zio.aws.cloudhsm.model.HsmStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudhsm.model.HsmStatus =
      software.amazon.awssdk.services.cloudhsm.model.HsmStatus.TERMINATING
  }
  case object TERMINATED extends zio.aws.cloudhsm.model.HsmStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudhsm.model.HsmStatus =
      software.amazon.awssdk.services.cloudhsm.model.HsmStatus.TERMINATED
  }
  case object DEGRADED extends zio.aws.cloudhsm.model.HsmStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudhsm.model.HsmStatus =
      software.amazon.awssdk.services.cloudhsm.model.HsmStatus.DEGRADED
  }
}
