package zio.aws.cloudhsm.model
import zio.ZIO
import zio.aws.cloudhsm.model.primitives.AZ
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListAvailableZonesResponse(
    azList: Optional[Iterable[AZ]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudhsm.model.ListAvailableZonesResponse = {
    import ListAvailableZonesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudhsm.model.ListAvailableZonesResponse
      .builder()
      .optionallyWith(
        azList.map(value =>
          value.map { item =>
            AZ.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.azList)
      .build()
  }
  def asReadOnly: zio.aws.cloudhsm.model.ListAvailableZonesResponse.ReadOnly =
    zio.aws.cloudhsm.model.ListAvailableZonesResponse.wrap(buildAwsValue())
}
object ListAvailableZonesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudhsm.model.ListAvailableZonesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudhsm.model.ListAvailableZonesResponse =
      zio.aws.cloudhsm.model
        .ListAvailableZonesResponse(azList.map(value => value))
    def azList: Optional[List[AZ]]
    def getAzList: ZIO[Any, AwsError, List[AZ]] =
      AwsError.unwrapOptionField("azList", azList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudhsm.model.ListAvailableZonesResponse
  ) extends zio.aws.cloudhsm.model.ListAvailableZonesResponse.ReadOnly {
    override val azList: Optional[List[AZ]] = zio.aws.core.internal
      .optionalFromNullable(impl.azList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudhsm.model.primitives.AZ(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudhsm.model.ListAvailableZonesResponse
  ): zio.aws.cloudhsm.model.ListAvailableZonesResponse.ReadOnly = new Wrapper(
    impl
  )
}
