package zio.aws.cloudhsm.model
import zio.ZIO
import zio.aws.cloudhsm.model.primitives.PaginationToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListHapgsRequest(
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudhsm.model.ListHapgsRequest = {
    import ListHapgsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudhsm.model.ListHapgsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.cloudhsm.model.ListHapgsRequest.ReadOnly =
    zio.aws.cloudhsm.model.ListHapgsRequest.wrap(buildAwsValue())
}
object ListHapgsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudhsm.model.ListHapgsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudhsm.model.ListHapgsRequest =
      zio.aws.cloudhsm.model.ListHapgsRequest(nextToken.map(value => value))
    def nextToken: Optional[PaginationToken]
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudhsm.model.ListHapgsRequest
  ) extends zio.aws.cloudhsm.model.ListHapgsRequest.ReadOnly {
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.cloudhsm.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudhsm.model.ListHapgsRequest
  ): zio.aws.cloudhsm.model.ListHapgsRequest.ReadOnly = new Wrapper(impl)
}
