package zio.aws.cloudhsm.model
import zio.ZIO
import zio.aws.cloudhsm.model.primitives.{PaginationToken, HapgArn}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListHapgsResponse(
    hapgList: Iterable[HapgArn],
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudhsm.model.ListHapgsResponse = {
    import ListHapgsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudhsm.model.ListHapgsResponse
      .builder()
      .hapgList(hapgList.map { item =>
        HapgArn.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.cloudhsm.model.ListHapgsResponse.ReadOnly =
    zio.aws.cloudhsm.model.ListHapgsResponse.wrap(buildAwsValue())
}
object ListHapgsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudhsm.model.ListHapgsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudhsm.model.ListHapgsResponse =
      zio.aws.cloudhsm.model
        .ListHapgsResponse(hapgList, nextToken.map(value => value))
    def hapgList: List[HapgArn]
    def nextToken: Optional[PaginationToken]
    def getHapgList: ZIO[Any, Nothing, List[HapgArn]] = ZIO.succeed(hapgList)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudhsm.model.ListHapgsResponse
  ) extends zio.aws.cloudhsm.model.ListHapgsResponse.ReadOnly {
    override val hapgList: List[HapgArn] = impl
      .hapgList()
      .asScala
      .map { item =>
        zio.aws.cloudhsm.model.primitives.HapgArn(item)
      }
      .toList
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.cloudhsm.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudhsm.model.ListHapgsResponse
  ): zio.aws.cloudhsm.model.ListHapgsResponse.ReadOnly = new Wrapper(impl)
}
