package zio.aws.cloudhsm.model
import zio.ZIO
import zio.aws.cloudhsm.model.primitives.PaginationToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListHsmsRequest(
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudhsm.model.ListHsmsRequest = {
    import ListHsmsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudhsm.model.ListHsmsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.cloudhsm.model.ListHsmsRequest.ReadOnly =
    zio.aws.cloudhsm.model.ListHsmsRequest.wrap(buildAwsValue())
}
object ListHsmsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudhsm.model.ListHsmsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudhsm.model.ListHsmsRequest =
      zio.aws.cloudhsm.model.ListHsmsRequest(nextToken.map(value => value))
    def nextToken: Optional[PaginationToken]
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudhsm.model.ListHsmsRequest
  ) extends zio.aws.cloudhsm.model.ListHsmsRequest.ReadOnly {
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.cloudhsm.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudhsm.model.ListHsmsRequest
  ): zio.aws.cloudhsm.model.ListHsmsRequest.ReadOnly = new Wrapper(impl)
}
