package zio.aws.cloudhsm
import zio.aws.cloudhsm.model.ListTagsForResourceResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import zio.aws.cloudhsm.model.{
  ListHapgsRequest,
  CreateHapgRequest,
  AddTagsToResourceRequest,
  ListHsmsRequest,
  DescribeHsmRequest,
  ListTagsForResourceRequest,
  ModifyLunaClientRequest,
  ListLunaClientsRequest,
  DeleteHapgRequest,
  ModifyHapgRequest,
  ListAvailableZonesRequest,
  RemoveTagsFromResourceRequest,
  GetConfigRequest,
  DeleteHsmRequest,
  DescribeLunaClientRequest,
  CreateHsmRequest,
  DescribeHapgRequest,
  ModifyHsmRequest,
  DeleteLunaClientRequest,
  CreateLunaClientRequest
}
import zio.aws.core.{AwsServiceBase, AwsError}
import software.amazon.awssdk.services.cloudhsm.{
  CloudHsmAsyncClientBuilder,
  CloudHsmAsyncClient
}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.aws.cloudhsm.model.primitives.{ClientArn, HapgArn, HsmArn}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import software.amazon.awssdk.services.cloudhsm.model.{
  DescribeHsmResponse,
  RemoveTagsFromResourceResponse,
  DeleteHsmResponse,
  ListHapgsResponse,
  ModifyHapgResponse,
  ListAvailableZonesResponse,
  CreateHsmResponse,
  CreateLunaClientResponse,
  ListTagsForResourceResponse,
  DeleteLunaClientResponse,
  DeleteHapgResponse,
  ListHsmsResponse,
  ModifyLunaClientResponse,
  DescribeLunaClientResponse,
  AddTagsToResourceResponse,
  ListLunaClientsResponse,
  DescribeHapgResponse,
  ModifyHsmResponse,
  GetConfigResponse,
  CreateHapgResponse
}
import zio.stream.ZStream
import scala.jdk.CollectionConverters._
trait CloudHsm extends AspectSupport[CloudHsm] {
  val api: CloudHsmAsyncClient
  def addTagsToResource(
      request: AddTagsToResourceRequest
  ): IO[AwsError, zio.aws.cloudhsm.model.AddTagsToResourceResponse.ReadOnly]
  def listHsms(request: ListHsmsRequest): ZStream[Any, AwsError, HsmArn]
  def listHsmsPaginated(
      request: ListHsmsRequest
  ): IO[AwsError, zio.aws.cloudhsm.model.ListHsmsResponse.ReadOnly]
  def createHapg(
      request: CreateHapgRequest
  ): IO[AwsError, zio.aws.cloudhsm.model.CreateHapgResponse.ReadOnly]
  def describeHapg(
      request: DescribeHapgRequest
  ): IO[AwsError, zio.aws.cloudhsm.model.DescribeHapgResponse.ReadOnly]
  def modifyLunaClient(
      request: ModifyLunaClientRequest
  ): IO[AwsError, zio.aws.cloudhsm.model.ModifyLunaClientResponse.ReadOnly]
  def removeTagsFromResource(request: RemoveTagsFromResourceRequest): IO[
    AwsError,
    zio.aws.cloudhsm.model.RemoveTagsFromResourceResponse.ReadOnly
  ]
  def listAvailableZones(
      request: ListAvailableZonesRequest
  ): IO[AwsError, zio.aws.cloudhsm.model.ListAvailableZonesResponse.ReadOnly]
  def createLunaClient(
      request: CreateLunaClientRequest
  ): IO[AwsError, zio.aws.cloudhsm.model.CreateLunaClientResponse.ReadOnly]
  def createHsm(
      request: CreateHsmRequest
  ): IO[AwsError, zio.aws.cloudhsm.model.CreateHsmResponse.ReadOnly]
  def getConfig(
      request: GetConfigRequest
  ): IO[AwsError, zio.aws.cloudhsm.model.GetConfigResponse.ReadOnly]
  def listHapgs(request: ListHapgsRequest): ZStream[Any, AwsError, HapgArn]
  def listHapgsPaginated(
      request: ListHapgsRequest
  ): IO[AwsError, zio.aws.cloudhsm.model.ListHapgsResponse.ReadOnly]
  def describeLunaClient(
      request: DescribeLunaClientRequest
  ): IO[AwsError, zio.aws.cloudhsm.model.DescribeLunaClientResponse.ReadOnly]
  def deleteHsm(
      request: DeleteHsmRequest
  ): IO[AwsError, zio.aws.cloudhsm.model.DeleteHsmResponse.ReadOnly]
  def listLunaClients(
      request: ListLunaClientsRequest
  ): ZStream[Any, AwsError, ClientArn]
  def listLunaClientsPaginated(
      request: ListLunaClientsRequest
  ): IO[AwsError, zio.aws.cloudhsm.model.ListLunaClientsResponse.ReadOnly]
  def listTagsForResource(
      request: ListTagsForResourceRequest
  ): IO[AwsError, ReadOnly]
  def deleteHapg(
      request: DeleteHapgRequest
  ): IO[AwsError, zio.aws.cloudhsm.model.DeleteHapgResponse.ReadOnly]
  def deleteLunaClient(
      request: DeleteLunaClientRequest
  ): IO[AwsError, zio.aws.cloudhsm.model.DeleteLunaClientResponse.ReadOnly]
  def describeHsm(
      request: DescribeHsmRequest
  ): IO[AwsError, zio.aws.cloudhsm.model.DescribeHsmResponse.ReadOnly]
  def modifyHapg(
      request: ModifyHapgRequest
  ): IO[AwsError, zio.aws.cloudhsm.model.ModifyHapgResponse.ReadOnly]
  def modifyHsm(
      request: ModifyHsmRequest
  ): IO[AwsError, zio.aws.cloudhsm.model.ModifyHsmResponse.ReadOnly]
}
object CloudHsm {
  val live: ZLayer[AwsConfig, java.lang.Throwable, CloudHsm] = customized(
    identity
  )
  def customized(
      customization: CloudHsmAsyncClientBuilder => CloudHsmAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, CloudHsm] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: CloudHsmAsyncClientBuilder => CloudHsmAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, CloudHsm] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = CloudHsmAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[CloudHsmAsyncClient, CloudHsmAsyncClientBuilder](
      builder
    );
    b1 <- awsConfig
      .configureHttpClient[CloudHsmAsyncClient, CloudHsmAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      ); client <- ZIO.attempt(customization(b1).build())
  ) yield new CloudHsmImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class CloudHsmImpl[R](
      override val api: CloudHsmAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends CloudHsm
      with AwsServiceBase[R] {
    override val serviceName: String = "CloudHsm"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): CloudHsmImpl[R1] = new CloudHsmImpl(api, newAspect, r)
    def addTagsToResource(
        request: AddTagsToResourceRequest
    ): IO[AwsError, zio.aws.cloudhsm.model.AddTagsToResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloudhsm.model.AddTagsToResourceRequest,
        AddTagsToResourceResponse
      ]("addTagsToResource", api.addTagsToResource)(request.buildAwsValue())
        .map(zio.aws.cloudhsm.model.AddTagsToResourceResponse.wrap)
        .provideEnvironment(r)
    def listHsms(request: ListHsmsRequest): ZStream[Any, AwsError, HsmArn] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.cloudhsm.model.ListHsmsRequest,
        ListHsmsResponse,
        java.lang.String
      ](
        "listHsms",
        api.listHsms,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.hsmList().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.cloudhsm.model.primitives.HsmArn(item))
        .provideEnvironment(r)
    def listHsmsPaginated(
        request: ListHsmsRequest
    ): IO[AwsError, zio.aws.cloudhsm.model.ListHsmsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloudhsm.model.ListHsmsRequest,
        ListHsmsResponse
      ]("listHsms", api.listHsms)(request.buildAwsValue())
        .map(zio.aws.cloudhsm.model.ListHsmsResponse.wrap)
        .provideEnvironment(r)
    def createHapg(
        request: CreateHapgRequest
    ): IO[AwsError, zio.aws.cloudhsm.model.CreateHapgResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloudhsm.model.CreateHapgRequest,
        CreateHapgResponse
      ]("createHapg", api.createHapg)(request.buildAwsValue())
        .map(zio.aws.cloudhsm.model.CreateHapgResponse.wrap)
        .provideEnvironment(r)
    def describeHapg(
        request: DescribeHapgRequest
    ): IO[AwsError, zio.aws.cloudhsm.model.DescribeHapgResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloudhsm.model.DescribeHapgRequest,
        DescribeHapgResponse
      ]("describeHapg", api.describeHapg)(request.buildAwsValue())
        .map(zio.aws.cloudhsm.model.DescribeHapgResponse.wrap)
        .provideEnvironment(r)
    def modifyLunaClient(
        request: ModifyLunaClientRequest
    ): IO[AwsError, zio.aws.cloudhsm.model.ModifyLunaClientResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloudhsm.model.ModifyLunaClientRequest,
        ModifyLunaClientResponse
      ]("modifyLunaClient", api.modifyLunaClient)(request.buildAwsValue())
        .map(zio.aws.cloudhsm.model.ModifyLunaClientResponse.wrap)
        .provideEnvironment(r)
    def removeTagsFromResource(request: RemoveTagsFromResourceRequest): IO[
      AwsError,
      zio.aws.cloudhsm.model.RemoveTagsFromResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudhsm.model.RemoveTagsFromResourceRequest,
      RemoveTagsFromResourceResponse
    ]("removeTagsFromResource", api.removeTagsFromResource)(
      request.buildAwsValue()
    ).map(zio.aws.cloudhsm.model.RemoveTagsFromResourceResponse.wrap)
      .provideEnvironment(r)
    def listAvailableZones(request: ListAvailableZonesRequest): IO[
      AwsError,
      zio.aws.cloudhsm.model.ListAvailableZonesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudhsm.model.ListAvailableZonesRequest,
      ListAvailableZonesResponse
    ]("listAvailableZones", api.listAvailableZones)(request.buildAwsValue())
      .map(zio.aws.cloudhsm.model.ListAvailableZonesResponse.wrap)
      .provideEnvironment(r)
    def createLunaClient(
        request: CreateLunaClientRequest
    ): IO[AwsError, zio.aws.cloudhsm.model.CreateLunaClientResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloudhsm.model.CreateLunaClientRequest,
        CreateLunaClientResponse
      ]("createLunaClient", api.createLunaClient)(request.buildAwsValue())
        .map(zio.aws.cloudhsm.model.CreateLunaClientResponse.wrap)
        .provideEnvironment(r)
    def createHsm(
        request: CreateHsmRequest
    ): IO[AwsError, zio.aws.cloudhsm.model.CreateHsmResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloudhsm.model.CreateHsmRequest,
        CreateHsmResponse
      ]("createHsm", api.createHsm)(request.buildAwsValue())
        .map(zio.aws.cloudhsm.model.CreateHsmResponse.wrap)
        .provideEnvironment(r)
    def getConfig(
        request: GetConfigRequest
    ): IO[AwsError, zio.aws.cloudhsm.model.GetConfigResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloudhsm.model.GetConfigRequest,
        GetConfigResponse
      ]("getConfig", api.getConfig)(request.buildAwsValue())
        .map(zio.aws.cloudhsm.model.GetConfigResponse.wrap)
        .provideEnvironment(r)
    def listHapgs(request: ListHapgsRequest): ZStream[Any, AwsError, HapgArn] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.cloudhsm.model.ListHapgsRequest,
        ListHapgsResponse,
        java.lang.String
      ](
        "listHapgs",
        api.listHapgs,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.hapgList().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.cloudhsm.model.primitives.HapgArn(item))
        .provideEnvironment(r)
    def listHapgsPaginated(
        request: ListHapgsRequest
    ): IO[AwsError, zio.aws.cloudhsm.model.ListHapgsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloudhsm.model.ListHapgsRequest,
        ListHapgsResponse
      ]("listHapgs", api.listHapgs)(request.buildAwsValue())
        .map(zio.aws.cloudhsm.model.ListHapgsResponse.wrap)
        .provideEnvironment(r)
    def describeLunaClient(request: DescribeLunaClientRequest): IO[
      AwsError,
      zio.aws.cloudhsm.model.DescribeLunaClientResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudhsm.model.DescribeLunaClientRequest,
      DescribeLunaClientResponse
    ]("describeLunaClient", api.describeLunaClient)(request.buildAwsValue())
      .map(zio.aws.cloudhsm.model.DescribeLunaClientResponse.wrap)
      .provideEnvironment(r)
    def deleteHsm(
        request: DeleteHsmRequest
    ): IO[AwsError, zio.aws.cloudhsm.model.DeleteHsmResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloudhsm.model.DeleteHsmRequest,
        DeleteHsmResponse
      ]("deleteHsm", api.deleteHsm)(request.buildAwsValue())
        .map(zio.aws.cloudhsm.model.DeleteHsmResponse.wrap)
        .provideEnvironment(r)
    def listLunaClients(
        request: ListLunaClientsRequest
    ): ZStream[Any, AwsError, ClientArn] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.cloudhsm.model.ListLunaClientsRequest,
      ListLunaClientsResponse,
      java.lang.String
    ](
      "listLunaClients",
      api.listLunaClients,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.clientList().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.cloudhsm.model.primitives.ClientArn(item))
      .provideEnvironment(r)
    def listLunaClientsPaginated(
        request: ListLunaClientsRequest
    ): IO[AwsError, zio.aws.cloudhsm.model.ListLunaClientsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloudhsm.model.ListLunaClientsRequest,
        ListLunaClientsResponse
      ]("listLunaClients", api.listLunaClients)(request.buildAwsValue())
        .map(zio.aws.cloudhsm.model.ListLunaClientsResponse.wrap)
        .provideEnvironment(r)
    def listTagsForResource(
        request: ListTagsForResourceRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudhsm.model.ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.cloudhsm.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def deleteHapg(
        request: DeleteHapgRequest
    ): IO[AwsError, zio.aws.cloudhsm.model.DeleteHapgResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloudhsm.model.DeleteHapgRequest,
        DeleteHapgResponse
      ]("deleteHapg", api.deleteHapg)(request.buildAwsValue())
        .map(zio.aws.cloudhsm.model.DeleteHapgResponse.wrap)
        .provideEnvironment(r)
    def deleteLunaClient(
        request: DeleteLunaClientRequest
    ): IO[AwsError, zio.aws.cloudhsm.model.DeleteLunaClientResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloudhsm.model.DeleteLunaClientRequest,
        DeleteLunaClientResponse
      ]("deleteLunaClient", api.deleteLunaClient)(request.buildAwsValue())
        .map(zio.aws.cloudhsm.model.DeleteLunaClientResponse.wrap)
        .provideEnvironment(r)
    def describeHsm(
        request: DescribeHsmRequest
    ): IO[AwsError, zio.aws.cloudhsm.model.DescribeHsmResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloudhsm.model.DescribeHsmRequest,
        DescribeHsmResponse
      ]("describeHsm", api.describeHsm)(request.buildAwsValue())
        .map(zio.aws.cloudhsm.model.DescribeHsmResponse.wrap)
        .provideEnvironment(r)
    def modifyHapg(
        request: ModifyHapgRequest
    ): IO[AwsError, zio.aws.cloudhsm.model.ModifyHapgResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloudhsm.model.ModifyHapgRequest,
        ModifyHapgResponse
      ]("modifyHapg", api.modifyHapg)(request.buildAwsValue())
        .map(zio.aws.cloudhsm.model.ModifyHapgResponse.wrap)
        .provideEnvironment(r)
    def modifyHsm(
        request: ModifyHsmRequest
    ): IO[AwsError, zio.aws.cloudhsm.model.ModifyHsmResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloudhsm.model.ModifyHsmRequest,
        ModifyHsmResponse
      ]("modifyHsm", api.modifyHsm)(request.buildAwsValue())
        .map(zio.aws.cloudhsm.model.ModifyHsmResponse.wrap)
        .provideEnvironment(r)
  }
  def addTagsToResource(request: AddTagsToResourceRequest): ZIO[
    zio.aws.cloudhsm.CloudHsm,
    AwsError,
    zio.aws.cloudhsm.model.AddTagsToResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.addTagsToResource(request))
  def listHsms(
      request: ListHsmsRequest
  ): ZStream[zio.aws.cloudhsm.CloudHsm, AwsError, HsmArn] =
    ZStream.serviceWithStream(_.listHsms(request))
  def listHsmsPaginated(request: ListHsmsRequest): ZIO[
    zio.aws.cloudhsm.CloudHsm,
    AwsError,
    zio.aws.cloudhsm.model.ListHsmsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listHsmsPaginated(request))
  def createHapg(request: CreateHapgRequest): ZIO[
    zio.aws.cloudhsm.CloudHsm,
    AwsError,
    zio.aws.cloudhsm.model.CreateHapgResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createHapg(request))
  def describeHapg(request: DescribeHapgRequest): ZIO[
    zio.aws.cloudhsm.CloudHsm,
    AwsError,
    zio.aws.cloudhsm.model.DescribeHapgResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeHapg(request))
  def modifyLunaClient(request: ModifyLunaClientRequest): ZIO[
    zio.aws.cloudhsm.CloudHsm,
    AwsError,
    zio.aws.cloudhsm.model.ModifyLunaClientResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyLunaClient(request))
  def removeTagsFromResource(request: RemoveTagsFromResourceRequest): ZIO[
    zio.aws.cloudhsm.CloudHsm,
    AwsError,
    zio.aws.cloudhsm.model.RemoveTagsFromResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.removeTagsFromResource(request))
  def listAvailableZones(request: ListAvailableZonesRequest): ZIO[
    zio.aws.cloudhsm.CloudHsm,
    AwsError,
    zio.aws.cloudhsm.model.ListAvailableZonesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAvailableZones(request))
  def createLunaClient(request: CreateLunaClientRequest): ZIO[
    zio.aws.cloudhsm.CloudHsm,
    AwsError,
    zio.aws.cloudhsm.model.CreateLunaClientResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createLunaClient(request))
  def createHsm(request: CreateHsmRequest): ZIO[
    zio.aws.cloudhsm.CloudHsm,
    AwsError,
    zio.aws.cloudhsm.model.CreateHsmResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createHsm(request))
  def getConfig(request: GetConfigRequest): ZIO[
    zio.aws.cloudhsm.CloudHsm,
    AwsError,
    zio.aws.cloudhsm.model.GetConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getConfig(request))
  def listHapgs(
      request: ListHapgsRequest
  ): ZStream[zio.aws.cloudhsm.CloudHsm, AwsError, HapgArn] =
    ZStream.serviceWithStream(_.listHapgs(request))
  def listHapgsPaginated(request: ListHapgsRequest): ZIO[
    zio.aws.cloudhsm.CloudHsm,
    AwsError,
    zio.aws.cloudhsm.model.ListHapgsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listHapgsPaginated(request))
  def describeLunaClient(request: DescribeLunaClientRequest): ZIO[
    zio.aws.cloudhsm.CloudHsm,
    AwsError,
    zio.aws.cloudhsm.model.DescribeLunaClientResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeLunaClient(request))
  def deleteHsm(request: DeleteHsmRequest): ZIO[
    zio.aws.cloudhsm.CloudHsm,
    AwsError,
    zio.aws.cloudhsm.model.DeleteHsmResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteHsm(request))
  def listLunaClients(
      request: ListLunaClientsRequest
  ): ZStream[zio.aws.cloudhsm.CloudHsm, AwsError, ClientArn] =
    ZStream.serviceWithStream(_.listLunaClients(request))
  def listLunaClientsPaginated(request: ListLunaClientsRequest): ZIO[
    zio.aws.cloudhsm.CloudHsm,
    AwsError,
    zio.aws.cloudhsm.model.ListLunaClientsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listLunaClientsPaginated(request))
  def listTagsForResource(
      request: ListTagsForResourceRequest
  ): ZIO[zio.aws.cloudhsm.CloudHsm, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.listTagsForResource(request))
  def deleteHapg(request: DeleteHapgRequest): ZIO[
    zio.aws.cloudhsm.CloudHsm,
    AwsError,
    zio.aws.cloudhsm.model.DeleteHapgResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteHapg(request))
  def deleteLunaClient(request: DeleteLunaClientRequest): ZIO[
    zio.aws.cloudhsm.CloudHsm,
    AwsError,
    zio.aws.cloudhsm.model.DeleteLunaClientResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteLunaClient(request))
  def describeHsm(request: DescribeHsmRequest): ZIO[
    zio.aws.cloudhsm.CloudHsm,
    AwsError,
    zio.aws.cloudhsm.model.DescribeHsmResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeHsm(request))
  def modifyHapg(request: ModifyHapgRequest): ZIO[
    zio.aws.cloudhsm.CloudHsm,
    AwsError,
    zio.aws.cloudhsm.model.ModifyHapgResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyHapg(request))
  def modifyHsm(request: ModifyHsmRequest): ZIO[
    zio.aws.cloudhsm.CloudHsm,
    AwsError,
    zio.aws.cloudhsm.model.ModifyHsmResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyHsm(request))
}
