package zio.aws.cloudhsm.model
import zio.ZIO
import zio.aws.cloudhsm.model.primitives.HsmArn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteHsmRequest(hsmArn: HsmArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudhsm.model.DeleteHsmRequest = {
    import DeleteHsmRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudhsm.model.DeleteHsmRequest
      .builder()
      .hsmArn(HsmArn.unwrap(hsmArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.cloudhsm.model.DeleteHsmRequest.ReadOnly =
    zio.aws.cloudhsm.model.DeleteHsmRequest.wrap(buildAwsValue())
}
object DeleteHsmRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudhsm.model.DeleteHsmRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudhsm.model.DeleteHsmRequest =
      zio.aws.cloudhsm.model.DeleteHsmRequest(hsmArn)
    def hsmArn: HsmArn
    def getHsmArn: ZIO[Any, Nothing, HsmArn] = ZIO.succeed(hsmArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudhsm.model.DeleteHsmRequest
  ) extends zio.aws.cloudhsm.model.DeleteHsmRequest.ReadOnly {
    override val hsmArn: HsmArn =
      zio.aws.cloudhsm.model.primitives.HsmArn(impl.hsmArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudhsm.model.DeleteHsmRequest
  ): zio.aws.cloudhsm.model.DeleteHsmRequest.ReadOnly = new Wrapper(impl)
}
