package zio.aws.cloudhsm.model
import zio.ZIO
import zio.aws.cloudhsm.model.primitives.{TagValue, TagKey}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class Tag(key: TagKey, value: TagValue) {
  def buildAwsValue(): software.amazon.awssdk.services.cloudhsm.model.Tag = {
    import Tag.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudhsm.model.Tag
      .builder()
      .key(TagKey.unwrap(key): java.lang.String)
      .value(TagValue.unwrap(value): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.cloudhsm.model.Tag.ReadOnly =
    zio.aws.cloudhsm.model.Tag.wrap(buildAwsValue())
}
object Tag {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.cloudhsm.model.Tag] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudhsm.model.Tag =
      zio.aws.cloudhsm.model.Tag(key, value)
    def key: TagKey
    def value: TagValue
    def getKey: ZIO[Any, Nothing, TagKey] = ZIO.succeed(key)
    def getValue: ZIO[Any, Nothing, TagValue] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudhsm.model.Tag
  ) extends zio.aws.cloudhsm.model.Tag.ReadOnly {
    override val key: TagKey =
      zio.aws.cloudhsm.model.primitives.TagKey(impl.key())
    override val value: TagValue =
      zio.aws.cloudhsm.model.primitives.TagValue(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudhsm.model.Tag
  ): zio.aws.cloudhsm.model.Tag.ReadOnly = new Wrapper(impl)
}
