package zio.aws.cloudhsm.model
import zio.ZIO
import zio.aws.cloudhsm.model.primitives.Label
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateHapgRequest(label: Label) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudhsm.model.CreateHapgRequest = {
    import CreateHapgRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudhsm.model.CreateHapgRequest
      .builder()
      .label(Label.unwrap(label): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.cloudhsm.model.CreateHapgRequest.ReadOnly =
    zio.aws.cloudhsm.model.CreateHapgRequest.wrap(buildAwsValue())
}
object CreateHapgRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudhsm.model.CreateHapgRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudhsm.model.CreateHapgRequest =
      zio.aws.cloudhsm.model.CreateHapgRequest(label)
    def label: Label
    def getLabel: ZIO[Any, Nothing, Label] = ZIO.succeed(label)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudhsm.model.CreateHapgRequest
  ) extends zio.aws.cloudhsm.model.CreateHapgRequest.ReadOnly {
    override val label: Label =
      zio.aws.cloudhsm.model.primitives.Label(impl.label())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudhsm.model.CreateHapgRequest
  ): zio.aws.cloudhsm.model.CreateHapgRequest.ReadOnly = new Wrapper(impl)
}
