package zio.aws.cloudhsm.model
import zio.ZIO
import zio.aws.cloudhsm.model.primitives.ClientArn
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateLunaClientResponse(
    clientArn: Optional[ClientArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudhsm.model.CreateLunaClientResponse = {
    import CreateLunaClientResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudhsm.model.CreateLunaClientResponse
      .builder()
      .optionallyWith(
        clientArn.map(value => ClientArn.unwrap(value): java.lang.String)
      )(_.clientArn)
      .build()
  }
  def asReadOnly: zio.aws.cloudhsm.model.CreateLunaClientResponse.ReadOnly =
    zio.aws.cloudhsm.model.CreateLunaClientResponse.wrap(buildAwsValue())
}
object CreateLunaClientResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudhsm.model.CreateLunaClientResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudhsm.model.CreateLunaClientResponse =
      zio.aws.cloudhsm.model
        .CreateLunaClientResponse(clientArn.map(value => value))
    def clientArn: Optional[ClientArn]
    def getClientArn: ZIO[Any, AwsError, ClientArn] =
      AwsError.unwrapOptionField("clientArn", clientArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudhsm.model.CreateLunaClientResponse
  ) extends zio.aws.cloudhsm.model.CreateLunaClientResponse.ReadOnly {
    override val clientArn: Optional[ClientArn] = zio.aws.core.internal
      .optionalFromNullable(impl.clientArn())
      .map(value => zio.aws.cloudhsm.model.primitives.ClientArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudhsm.model.CreateLunaClientResponse
  ): zio.aws.cloudhsm.model.CreateLunaClientResponse.ReadOnly = new Wrapper(
    impl
  )
}
