package zio.aws.cloudhsm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetConfigResponse(
    configType: Optional[String] = Optional.Absent,
    configFile: Optional[String] = Optional.Absent,
    configCred: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudhsm.model.GetConfigResponse = {
    import GetConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudhsm.model.GetConfigResponse
      .builder()
      .optionallyWith(configType.map(value => value: java.lang.String))(
        _.configType
      )
      .optionallyWith(configFile.map(value => value: java.lang.String))(
        _.configFile
      )
      .optionallyWith(configCred.map(value => value: java.lang.String))(
        _.configCred
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudhsm.model.GetConfigResponse.ReadOnly =
    zio.aws.cloudhsm.model.GetConfigResponse.wrap(buildAwsValue())
}
object GetConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudhsm.model.GetConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudhsm.model.GetConfigResponse =
      zio.aws.cloudhsm.model.GetConfigResponse(
        configType.map(value => value),
        configFile.map(value => value),
        configCred.map(value => value)
      )
    def configType: Optional[String]
    def configFile: Optional[String]
    def configCred: Optional[String]
    def getConfigType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("configType", configType)
    def getConfigFile: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("configFile", configFile)
    def getConfigCred: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("configCred", configCred)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudhsm.model.GetConfigResponse
  ) extends zio.aws.cloudhsm.model.GetConfigResponse.ReadOnly {
    override val configType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.configType())
      .map(value => value: String)
    override val configFile: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.configFile())
      .map(value => value: String)
    override val configCred: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.configCred())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudhsm.model.GetConfigResponse
  ): zio.aws.cloudhsm.model.GetConfigResponse.ReadOnly = new Wrapper(impl)
}
