package zio.aws.cloudhsm.model
import zio.ZIO
import zio.aws.cloudhsm.model.primitives.TagKey
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class RemoveTagsFromResourceRequest(
    resourceArn: String,
    tagKeyList: Iterable[TagKey]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudhsm.model.RemoveTagsFromResourceRequest = {
    import RemoveTagsFromResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudhsm.model.RemoveTagsFromResourceRequest
      .builder()
      .resourceArn(resourceArn: java.lang.String)
      .tagKeyList(tagKeyList.map { item =>
        TagKey.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudhsm.model.RemoveTagsFromResourceRequest.ReadOnly =
    zio.aws.cloudhsm.model.RemoveTagsFromResourceRequest.wrap(buildAwsValue())
}
object RemoveTagsFromResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudhsm.model.RemoveTagsFromResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudhsm.model.RemoveTagsFromResourceRequest =
      zio.aws.cloudhsm.model
        .RemoveTagsFromResourceRequest(resourceArn, tagKeyList)
    def resourceArn: String
    def tagKeyList: List[TagKey]
    def getResourceArn: ZIO[Any, Nothing, String] = ZIO.succeed(resourceArn)
    def getTagKeyList: ZIO[Any, Nothing, List[TagKey]] = ZIO.succeed(tagKeyList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudhsm.model.RemoveTagsFromResourceRequest
  ) extends zio.aws.cloudhsm.model.RemoveTagsFromResourceRequest.ReadOnly {
    override val resourceArn: String = impl.resourceArn(): String
    override val tagKeyList: List[TagKey] = impl
      .tagKeyList()
      .asScala
      .map { item =>
        zio.aws.cloudhsm.model.primitives.TagKey(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudhsm.model.RemoveTagsFromResourceRequest
  ): zio.aws.cloudhsm.model.RemoveTagsFromResourceRequest.ReadOnly =
    new Wrapper(impl)
}
