package zio.aws.cloudhsm.model
import zio.ZIO
import zio.aws.cloudhsm.model.primitives.{HsmSerialNumber, HsmArn}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeHsmRequest(
    hsmArn: Optional[HsmArn] = Optional.Absent,
    hsmSerialNumber: Optional[HsmSerialNumber] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudhsm.model.DescribeHsmRequest = {
    import DescribeHsmRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudhsm.model.DescribeHsmRequest
      .builder()
      .optionallyWith(
        hsmArn.map(value => HsmArn.unwrap(value): java.lang.String)
      )(_.hsmArn)
      .optionallyWith(
        hsmSerialNumber.map(value =>
          HsmSerialNumber.unwrap(value): java.lang.String
        )
      )(_.hsmSerialNumber)
      .build()
  }
  def asReadOnly: zio.aws.cloudhsm.model.DescribeHsmRequest.ReadOnly =
    zio.aws.cloudhsm.model.DescribeHsmRequest.wrap(buildAwsValue())
}
object DescribeHsmRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudhsm.model.DescribeHsmRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudhsm.model.DescribeHsmRequest =
      zio.aws.cloudhsm.model.DescribeHsmRequest(
        hsmArn.map(value => value),
        hsmSerialNumber.map(value => value)
      )
    def hsmArn: Optional[HsmArn]
    def hsmSerialNumber: Optional[HsmSerialNumber]
    def getHsmArn: ZIO[Any, AwsError, HsmArn] =
      AwsError.unwrapOptionField("hsmArn", hsmArn)
    def getHsmSerialNumber: ZIO[Any, AwsError, HsmSerialNumber] =
      AwsError.unwrapOptionField("hsmSerialNumber", hsmSerialNumber)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudhsm.model.DescribeHsmRequest
  ) extends zio.aws.cloudhsm.model.DescribeHsmRequest.ReadOnly {
    override val hsmArn: Optional[HsmArn] = zio.aws.core.internal
      .optionalFromNullable(impl.hsmArn())
      .map(value => zio.aws.cloudhsm.model.primitives.HsmArn(value))
    override val hsmSerialNumber: Optional[HsmSerialNumber] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hsmSerialNumber())
        .map(value => zio.aws.cloudhsm.model.primitives.HsmSerialNumber(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudhsm.model.DescribeHsmRequest
  ): zio.aws.cloudhsm.model.DescribeHsmRequest.ReadOnly = new Wrapper(impl)
}
