package zio.aws.cloudhsm.model
import zio.ZIO
import zio.aws.cloudhsm.model.primitives.{Certificate, ClientArn}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ModifyLunaClientRequest(
    clientArn: ClientArn,
    certificate: Certificate
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudhsm.model.ModifyLunaClientRequest = {
    import ModifyLunaClientRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudhsm.model.ModifyLunaClientRequest
      .builder()
      .clientArn(ClientArn.unwrap(clientArn): java.lang.String)
      .certificate(Certificate.unwrap(certificate): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.cloudhsm.model.ModifyLunaClientRequest.ReadOnly =
    zio.aws.cloudhsm.model.ModifyLunaClientRequest.wrap(buildAwsValue())
}
object ModifyLunaClientRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudhsm.model.ModifyLunaClientRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudhsm.model.ModifyLunaClientRequest =
      zio.aws.cloudhsm.model.ModifyLunaClientRequest(clientArn, certificate)
    def clientArn: ClientArn
    def certificate: Certificate
    def getClientArn: ZIO[Any, Nothing, ClientArn] = ZIO.succeed(clientArn)
    def getCertificate: ZIO[Any, Nothing, Certificate] =
      ZIO.succeed(certificate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudhsm.model.ModifyLunaClientRequest
  ) extends zio.aws.cloudhsm.model.ModifyLunaClientRequest.ReadOnly {
    override val clientArn: ClientArn =
      zio.aws.cloudhsm.model.primitives.ClientArn(impl.clientArn())
    override val certificate: Certificate =
      zio.aws.cloudhsm.model.primitives.Certificate(impl.certificate())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudhsm.model.ModifyLunaClientRequest
  ): zio.aws.cloudhsm.model.ModifyLunaClientRequest.ReadOnly = new Wrapper(impl)
}
