package zio.aws.cloudhsmv2.model
import zio.aws.cloudhsmv2.model.primitives.BackupId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteBackupRequest(backupId: BackupId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudhsmv2.model.DeleteBackupRequest = {
    import DeleteBackupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudhsmv2.model.DeleteBackupRequest
      .builder()
      .backupId(BackupId.unwrap(backupId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.cloudhsmv2.model.DeleteBackupRequest.ReadOnly =
    zio.aws.cloudhsmv2.model.DeleteBackupRequest.wrap(buildAwsValue())
}
object DeleteBackupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudhsmv2.model.DeleteBackupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudhsmv2.model.DeleteBackupRequest =
      zio.aws.cloudhsmv2.model.DeleteBackupRequest(backupId)
    def backupId: BackupId
    def getBackupId: ZIO[Any, Nothing, BackupId] = ZIO.succeed(backupId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudhsmv2.model.DeleteBackupRequest
  ) extends zio.aws.cloudhsmv2.model.DeleteBackupRequest.ReadOnly {
    override val backupId: BackupId =
      zio.aws.cloudhsmv2.model.primitives.BackupId(impl.backupId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudhsmv2.model.DeleteBackupRequest
  ): zio.aws.cloudhsmv2.model.DeleteBackupRequest.ReadOnly = new Wrapper(impl)
}
