package zio.aws.cloudhsmv2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.cloudhsmv2.model.primitives.{MaxSize, NextToken, ResourceId}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListTagsRequest(
    resourceId: ResourceId,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxSize] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudhsmv2.model.ListTagsRequest = {
    import ListTagsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudhsmv2.model.ListTagsRequest
      .builder()
      .resourceId(ResourceId.unwrap(resourceId): java.lang.String)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(maxResults.map(value => MaxSize.unwrap(value): Integer))(
        _.maxResults
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudhsmv2.model.ListTagsRequest.ReadOnly =
    zio.aws.cloudhsmv2.model.ListTagsRequest.wrap(buildAwsValue())
}
object ListTagsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudhsmv2.model.ListTagsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudhsmv2.model.ListTagsRequest =
      zio.aws.cloudhsmv2.model.ListTagsRequest(
        resourceId,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def resourceId: ResourceId
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxSize]
    def getResourceId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(resourceId)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxSize] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudhsmv2.model.ListTagsRequest
  ) extends zio.aws.cloudhsmv2.model.ListTagsRequest.ReadOnly {
    override val resourceId: ResourceId =
      zio.aws.cloudhsmv2.model.primitives.ResourceId(impl.resourceId())
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.cloudhsmv2.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxSize] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.cloudhsmv2.model.primitives.MaxSize(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudhsmv2.model.ListTagsRequest
  ): zio.aws.cloudhsmv2.model.ListTagsRequest.ReadOnly = new Wrapper(impl)
}
