package zio.aws.cloudwatch
import zio.aws.cloudwatch.model.PutAnomalyDetectorResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
import zio.aws.cloudwatch.model.{
  DescribeAlarmsForMetricRequest,
  DescribeInsightRulesRequest,
  DeleteDashboardsRequest,
  DescribeAlarmHistoryRequest,
  ListDashboardsRequest,
  DeleteAlarmsRequest,
  ListManagedInsightRulesRequest,
  StopMetricStreamsRequest,
  PutMetricStreamRequest,
  SetAlarmStateRequest,
  PutMetricDataRequest,
  DeleteAnomalyDetectorRequest,
  ListTagsForResourceRequest,
  PutInsightRuleRequest,
  PutMetricAlarmRequest,
  PutDashboardRequest,
  StartMetricStreamsRequest,
  EnableAlarmActionsRequest,
  PutCompositeAlarmRequest,
  DescribeAnomalyDetectorsRequest,
  GetDashboardRequest,
  GetMetricStreamRequest,
  ListMetricsRequest,
  GetMetricStatisticsRequest,
  ListMetricStreamsRequest,
  UntagResourceRequest,
  DisableAlarmActionsRequest,
  GetMetricDataRequest,
  EnableInsightRulesRequest,
  DeleteMetricStreamRequest,
  GetMetricWidgetImageRequest,
  GetInsightRuleReportRequest,
  PutManagedInsightRulesRequest,
  DeleteInsightRulesRequest,
  DescribeAlarmsRequest,
  TagResourceRequest,
  PutAnomalyDetectorRequest,
  DisableInsightRulesRequest
}
import software.amazon.awssdk.services.cloudwatch.CloudWatchAsyncClient
object CloudWatchMock extends Mock[CloudWatch] {
  object DeleteAnomalyDetector
      extends Effect[
        DeleteAnomalyDetectorRequest,
        AwsError,
        zio.aws.cloudwatch.model.DeleteAnomalyDetectorResponse.ReadOnly
      ]
  object PutMetricAlarm extends Effect[PutMetricAlarmRequest, AwsError, Unit]
  object ListManagedInsightRules
      extends Stream[
        ListManagedInsightRulesRequest,
        AwsError,
        zio.aws.cloudwatch.model.ManagedRuleDescription.ReadOnly
      ]
  object ListManagedInsightRulesPaginated
      extends Effect[
        ListManagedInsightRulesRequest,
        AwsError,
        zio.aws.cloudwatch.model.ListManagedInsightRulesResponse.ReadOnly
      ]
  object ListMetricStreams
      extends Stream[
        ListMetricStreamsRequest,
        AwsError,
        zio.aws.cloudwatch.model.MetricStreamEntry.ReadOnly
      ]
  object ListMetricStreamsPaginated
      extends Effect[
        ListMetricStreamsRequest,
        AwsError,
        zio.aws.cloudwatch.model.ListMetricStreamsResponse.ReadOnly
      ]
  object DescribeAlarmsForMetric
      extends Effect[
        DescribeAlarmsForMetricRequest,
        AwsError,
        zio.aws.cloudwatch.model.DescribeAlarmsForMetricResponse.ReadOnly
      ]
  object DescribeAlarms
      extends Stream[
        DescribeAlarmsRequest,
        AwsError,
        zio.aws.cloudwatch.model.MetricAlarm.ReadOnly
      ]
  object DescribeAlarmsPaginated
      extends Effect[
        DescribeAlarmsRequest,
        AwsError,
        zio.aws.cloudwatch.model.DescribeAlarmsResponse.ReadOnly
      ]
  object PutManagedInsightRules
      extends Effect[
        PutManagedInsightRulesRequest,
        AwsError,
        zio.aws.cloudwatch.model.PutManagedInsightRulesResponse.ReadOnly
      ]
  object DisableAlarmActions
      extends Effect[DisableAlarmActionsRequest, AwsError, Unit]
  object DeleteInsightRules
      extends Effect[
        DeleteInsightRulesRequest,
        AwsError,
        zio.aws.cloudwatch.model.DeleteInsightRulesResponse.ReadOnly
      ]
  object DescribeInsightRules
      extends Stream[
        DescribeInsightRulesRequest,
        AwsError,
        zio.aws.cloudwatch.model.InsightRule.ReadOnly
      ]
  object DescribeInsightRulesPaginated
      extends Effect[
        DescribeInsightRulesRequest,
        AwsError,
        zio.aws.cloudwatch.model.DescribeInsightRulesResponse.ReadOnly
      ]
  object PutDashboard
      extends Effect[
        PutDashboardRequest,
        AwsError,
        zio.aws.cloudwatch.model.PutDashboardResponse.ReadOnly
      ]
  object DescribeAlarmHistory
      extends Stream[
        DescribeAlarmHistoryRequest,
        AwsError,
        zio.aws.cloudwatch.model.AlarmHistoryItem.ReadOnly
      ]
  object DescribeAlarmHistoryPaginated
      extends Effect[
        DescribeAlarmHistoryRequest,
        AwsError,
        zio.aws.cloudwatch.model.DescribeAlarmHistoryResponse.ReadOnly
      ]
  object StopMetricStreams
      extends Effect[
        StopMetricStreamsRequest,
        AwsError,
        zio.aws.cloudwatch.model.StopMetricStreamsResponse.ReadOnly
      ]
  object GetMetricStream
      extends Effect[
        GetMetricStreamRequest,
        AwsError,
        zio.aws.cloudwatch.model.GetMetricStreamResponse.ReadOnly
      ]
  object GetMetricWidgetImage
      extends Effect[
        GetMetricWidgetImageRequest,
        AwsError,
        zio.aws.cloudwatch.model.GetMetricWidgetImageResponse.ReadOnly
      ]
  object GetMetricData
      extends Stream[
        GetMetricDataRequest,
        AwsError,
        zio.aws.cloudwatch.model.MetricDataResult.ReadOnly
      ]
  object GetMetricDataPaginated
      extends Effect[
        GetMetricDataRequest,
        AwsError,
        zio.aws.cloudwatch.model.GetMetricDataResponse.ReadOnly
      ]
  object GetInsightRuleReport
      extends Effect[
        GetInsightRuleReportRequest,
        AwsError,
        zio.aws.cloudwatch.model.GetInsightRuleReportResponse.ReadOnly
      ]
  object GetDashboard
      extends Effect[
        GetDashboardRequest,
        AwsError,
        zio.aws.cloudwatch.model.GetDashboardResponse.ReadOnly
      ]
  object EnableInsightRules
      extends Effect[
        EnableInsightRulesRequest,
        AwsError,
        zio.aws.cloudwatch.model.EnableInsightRulesResponse.ReadOnly
      ]
  object DeleteMetricStream
      extends Effect[
        DeleteMetricStreamRequest,
        AwsError,
        zio.aws.cloudwatch.model.DeleteMetricStreamResponse.ReadOnly
      ]
  object EnableAlarmActions
      extends Effect[EnableAlarmActionsRequest, AwsError, Unit]
  object ListDashboards
      extends Stream[
        ListDashboardsRequest,
        AwsError,
        zio.aws.cloudwatch.model.DashboardEntry.ReadOnly
      ]
  object ListDashboardsPaginated
      extends Effect[
        ListDashboardsRequest,
        AwsError,
        zio.aws.cloudwatch.model.ListDashboardsResponse.ReadOnly
      ]
  object PutMetricStream
      extends Effect[
        PutMetricStreamRequest,
        AwsError,
        zio.aws.cloudwatch.model.PutMetricStreamResponse.ReadOnly
      ]
  object DeleteDashboards
      extends Effect[
        DeleteDashboardsRequest,
        AwsError,
        zio.aws.cloudwatch.model.DeleteDashboardsResponse.ReadOnly
      ]
  object PutInsightRule
      extends Effect[
        PutInsightRuleRequest,
        AwsError,
        zio.aws.cloudwatch.model.PutInsightRuleResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.cloudwatch.model.UntagResourceResponse.ReadOnly
      ]
  object ListMetrics
      extends Stream[
        ListMetricsRequest,
        AwsError,
        zio.aws.cloudwatch.model.Metric.ReadOnly
      ]
  object ListMetricsPaginated
      extends Effect[
        ListMetricsRequest,
        AwsError,
        zio.aws.cloudwatch.model.ListMetricsResponse.ReadOnly
      ]
  object PutCompositeAlarm
      extends Effect[PutCompositeAlarmRequest, AwsError, Unit]
  object PutMetricData extends Effect[PutMetricDataRequest, AwsError, Unit]
  object StartMetricStreams
      extends Effect[
        StartMetricStreamsRequest,
        AwsError,
        zio.aws.cloudwatch.model.StartMetricStreamsResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.cloudwatch.model.ListTagsForResourceResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.cloudwatch.model.TagResourceResponse.ReadOnly
      ]
  object GetMetricStatistics
      extends Effect[
        GetMetricStatisticsRequest,
        AwsError,
        zio.aws.cloudwatch.model.GetMetricStatisticsResponse.ReadOnly
      ]
  object PutAnomalyDetector
      extends Effect[PutAnomalyDetectorRequest, AwsError, ReadOnly]
  object DescribeAnomalyDetectors
      extends Stream[
        DescribeAnomalyDetectorsRequest,
        AwsError,
        zio.aws.cloudwatch.model.AnomalyDetector.ReadOnly
      ]
  object DescribeAnomalyDetectorsPaginated
      extends Effect[
        DescribeAnomalyDetectorsRequest,
        AwsError,
        zio.aws.cloudwatch.model.DescribeAnomalyDetectorsResponse.ReadOnly
      ]
  object DeleteAlarms extends Effect[DeleteAlarmsRequest, AwsError, Unit]
  object DisableInsightRules
      extends Effect[
        DisableInsightRulesRequest,
        AwsError,
        zio.aws.cloudwatch.model.DisableInsightRulesResponse.ReadOnly
      ]
  object SetAlarmState extends Effect[SetAlarmStateRequest, AwsError, Unit]
  val compose: URLayer[Proxy, CloudWatch] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, CloudWatch] { rts =>
        zio.ZIO.succeed {
          new CloudWatch {
            val api: CloudWatchAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): CloudWatch = this
            def deleteAnomalyDetector(
                request: DeleteAnomalyDetectorRequest
            ): IO[
              AwsError,
              zio.aws.cloudwatch.model.DeleteAnomalyDetectorResponse.ReadOnly
            ] = proxy(DeleteAnomalyDetector, request)
            def putMetricAlarm(
                request: PutMetricAlarmRequest
            ): IO[AwsError, Unit] = proxy(PutMetricAlarm, request)
            def listManagedInsightRules(
                request: ListManagedInsightRulesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.cloudwatch.model.ManagedRuleDescription.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListManagedInsightRules, request)
                }
                .getOrThrowFiberFailure()
            }
            def listManagedInsightRulesPaginated(
                request: ListManagedInsightRulesRequest
            ): IO[
              AwsError,
              zio.aws.cloudwatch.model.ListManagedInsightRulesResponse.ReadOnly
            ] = proxy(ListManagedInsightRulesPaginated, request)
            def listMetricStreams(request: ListMetricStreamsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.cloudwatch.model.MetricStreamEntry.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListMetricStreams, request)
                }
                .getOrThrowFiberFailure()
            }
            def listMetricStreamsPaginated(
                request: ListMetricStreamsRequest
            ): IO[
              AwsError,
              zio.aws.cloudwatch.model.ListMetricStreamsResponse.ReadOnly
            ] = proxy(ListMetricStreamsPaginated, request)
            def describeAlarmsForMetric(
                request: DescribeAlarmsForMetricRequest
            ): IO[
              AwsError,
              zio.aws.cloudwatch.model.DescribeAlarmsForMetricResponse.ReadOnly
            ] = proxy(DescribeAlarmsForMetric, request)
            def describeAlarms(request: DescribeAlarmsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.cloudwatch.model.MetricAlarm.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribeAlarms, request)
                }
                .getOrThrowFiberFailure()
            }
            def describeAlarmsPaginated(request: DescribeAlarmsRequest): IO[
              AwsError,
              zio.aws.cloudwatch.model.DescribeAlarmsResponse.ReadOnly
            ] = proxy(DescribeAlarmsPaginated, request)
            def putManagedInsightRules(
                request: PutManagedInsightRulesRequest
            ): IO[
              AwsError,
              zio.aws.cloudwatch.model.PutManagedInsightRulesResponse.ReadOnly
            ] = proxy(PutManagedInsightRules, request)
            def disableAlarmActions(
                request: DisableAlarmActionsRequest
            ): IO[AwsError, Unit] = proxy(DisableAlarmActions, request)
            def deleteInsightRules(request: DeleteInsightRulesRequest): IO[
              AwsError,
              zio.aws.cloudwatch.model.DeleteInsightRulesResponse.ReadOnly
            ] = proxy(DeleteInsightRules, request)
            def describeInsightRules(
                request: DescribeInsightRulesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.cloudwatch.model.InsightRule.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribeInsightRules, request)
                }
                .getOrThrowFiberFailure()
            }
            def describeInsightRulesPaginated(
                request: DescribeInsightRulesRequest
            ): IO[
              AwsError,
              zio.aws.cloudwatch.model.DescribeInsightRulesResponse.ReadOnly
            ] = proxy(DescribeInsightRulesPaginated, request)
            def putDashboard(request: PutDashboardRequest): IO[
              AwsError,
              zio.aws.cloudwatch.model.PutDashboardResponse.ReadOnly
            ] = proxy(PutDashboard, request)
            def describeAlarmHistory(
                request: DescribeAlarmHistoryRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.cloudwatch.model.AlarmHistoryItem.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribeAlarmHistory, request)
                }
                .getOrThrowFiberFailure()
            }
            def describeAlarmHistoryPaginated(
                request: DescribeAlarmHistoryRequest
            ): IO[
              AwsError,
              zio.aws.cloudwatch.model.DescribeAlarmHistoryResponse.ReadOnly
            ] = proxy(DescribeAlarmHistoryPaginated, request)
            def stopMetricStreams(request: StopMetricStreamsRequest): IO[
              AwsError,
              zio.aws.cloudwatch.model.StopMetricStreamsResponse.ReadOnly
            ] = proxy(StopMetricStreams, request)
            def getMetricStream(request: GetMetricStreamRequest): IO[
              AwsError,
              zio.aws.cloudwatch.model.GetMetricStreamResponse.ReadOnly
            ] = proxy(GetMetricStream, request)
            def getMetricWidgetImage(request: GetMetricWidgetImageRequest): IO[
              AwsError,
              zio.aws.cloudwatch.model.GetMetricWidgetImageResponse.ReadOnly
            ] = proxy(GetMetricWidgetImage, request)
            def getMetricData(request: GetMetricDataRequest): ZStream[
              Any,
              AwsError,
              zio.aws.cloudwatch.model.MetricDataResult.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(GetMetricData, request)
                }
                .getOrThrowFiberFailure()
            }
            def getMetricDataPaginated(request: GetMetricDataRequest): IO[
              AwsError,
              zio.aws.cloudwatch.model.GetMetricDataResponse.ReadOnly
            ] = proxy(GetMetricDataPaginated, request)
            def getInsightRuleReport(request: GetInsightRuleReportRequest): IO[
              AwsError,
              zio.aws.cloudwatch.model.GetInsightRuleReportResponse.ReadOnly
            ] = proxy(GetInsightRuleReport, request)
            def getDashboard(request: GetDashboardRequest): IO[
              AwsError,
              zio.aws.cloudwatch.model.GetDashboardResponse.ReadOnly
            ] = proxy(GetDashboard, request)
            def enableInsightRules(request: EnableInsightRulesRequest): IO[
              AwsError,
              zio.aws.cloudwatch.model.EnableInsightRulesResponse.ReadOnly
            ] = proxy(EnableInsightRules, request)
            def deleteMetricStream(request: DeleteMetricStreamRequest): IO[
              AwsError,
              zio.aws.cloudwatch.model.DeleteMetricStreamResponse.ReadOnly
            ] = proxy(DeleteMetricStream, request)
            def enableAlarmActions(
                request: EnableAlarmActionsRequest
            ): IO[AwsError, Unit] = proxy(EnableAlarmActions, request)
            def listDashboards(request: ListDashboardsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.cloudwatch.model.DashboardEntry.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListDashboards, request)
                }
                .getOrThrowFiberFailure()
            }
            def listDashboardsPaginated(request: ListDashboardsRequest): IO[
              AwsError,
              zio.aws.cloudwatch.model.ListDashboardsResponse.ReadOnly
            ] = proxy(ListDashboardsPaginated, request)
            def putMetricStream(request: PutMetricStreamRequest): IO[
              AwsError,
              zio.aws.cloudwatch.model.PutMetricStreamResponse.ReadOnly
            ] = proxy(PutMetricStream, request)
            def deleteDashboards(request: DeleteDashboardsRequest): IO[
              AwsError,
              zio.aws.cloudwatch.model.DeleteDashboardsResponse.ReadOnly
            ] = proxy(DeleteDashboards, request)
            def putInsightRule(request: PutInsightRuleRequest): IO[
              AwsError,
              zio.aws.cloudwatch.model.PutInsightRuleResponse.ReadOnly
            ] = proxy(PutInsightRule, request)
            def untagResource(request: UntagResourceRequest): IO[
              AwsError,
              zio.aws.cloudwatch.model.UntagResourceResponse.ReadOnly
            ] = proxy(UntagResource, request)
            def listMetrics(request: ListMetricsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.cloudwatch.model.Metric.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListMetrics, request)
                }
                .getOrThrowFiberFailure()
            }
            def listMetricsPaginated(request: ListMetricsRequest): IO[
              AwsError,
              zio.aws.cloudwatch.model.ListMetricsResponse.ReadOnly
            ] = proxy(ListMetricsPaginated, request)
            def putCompositeAlarm(
                request: PutCompositeAlarmRequest
            ): IO[AwsError, Unit] = proxy(PutCompositeAlarm, request)
            def putMetricData(
                request: PutMetricDataRequest
            ): IO[AwsError, Unit] = proxy(PutMetricData, request)
            def startMetricStreams(request: StartMetricStreamsRequest): IO[
              AwsError,
              zio.aws.cloudwatch.model.StartMetricStreamsResponse.ReadOnly
            ] = proxy(StartMetricStreams, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.cloudwatch.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def tagResource(request: TagResourceRequest): IO[
              AwsError,
              zio.aws.cloudwatch.model.TagResourceResponse.ReadOnly
            ] = proxy(TagResource, request)
            def getMetricStatistics(request: GetMetricStatisticsRequest): IO[
              AwsError,
              zio.aws.cloudwatch.model.GetMetricStatisticsResponse.ReadOnly
            ] = proxy(GetMetricStatistics, request)
            def putAnomalyDetector(
                request: PutAnomalyDetectorRequest
            ): IO[AwsError, ReadOnly] = proxy(PutAnomalyDetector, request)
            def describeAnomalyDetectors(
                request: DescribeAnomalyDetectorsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.cloudwatch.model.AnomalyDetector.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribeAnomalyDetectors, request)
                }
                .getOrThrowFiberFailure()
            }
            def describeAnomalyDetectorsPaginated(
                request: DescribeAnomalyDetectorsRequest
            ): IO[
              AwsError,
              zio.aws.cloudwatch.model.DescribeAnomalyDetectorsResponse.ReadOnly
            ] = proxy(DescribeAnomalyDetectorsPaginated, request)
            def deleteAlarms(request: DeleteAlarmsRequest): IO[AwsError, Unit] =
              proxy(DeleteAlarms, request)
            def disableInsightRules(request: DisableInsightRulesRequest): IO[
              AwsError,
              zio.aws.cloudwatch.model.DisableInsightRulesResponse.ReadOnly
            ] = proxy(DisableInsightRules, request)
            def setAlarmState(
                request: SetAlarmStateRequest
            ): IO[AwsError, Unit] = proxy(SetAlarmState, request)
          }
        }
      }
    }
  }
}
