package zio.aws.cloudwatch.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.cloudwatch.model.primitives.{
  HistoryData,
  HistorySummary,
  Timestamp,
  AlarmName
}
import scala.jdk.CollectionConverters._
final case class AlarmHistoryItem(
    alarmName: Optional[AlarmName] = Optional.Absent,
    alarmType: Optional[zio.aws.cloudwatch.model.AlarmType] = Optional.Absent,
    timestamp: Optional[Timestamp] = Optional.Absent,
    historyItemType: Optional[zio.aws.cloudwatch.model.HistoryItemType] =
      Optional.Absent,
    historySummary: Optional[HistorySummary] = Optional.Absent,
    historyData: Optional[HistoryData] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.AlarmHistoryItem = {
    import AlarmHistoryItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.AlarmHistoryItem
      .builder()
      .optionallyWith(
        alarmName.map(value => AlarmName.unwrap(value): java.lang.String)
      )(_.alarmName)
      .optionallyWith(alarmType.map(value => value.unwrap))(_.alarmType)
      .optionallyWith(timestamp.map(value => Timestamp.unwrap(value): Instant))(
        _.timestamp
      )
      .optionallyWith(historyItemType.map(value => value.unwrap))(
        _.historyItemType
      )
      .optionallyWith(
        historySummary.map(value =>
          HistorySummary.unwrap(value): java.lang.String
        )
      )(_.historySummary)
      .optionallyWith(
        historyData.map(value => HistoryData.unwrap(value): java.lang.String)
      )(_.historyData)
      .build()
  }
  def asReadOnly: zio.aws.cloudwatch.model.AlarmHistoryItem.ReadOnly =
    zio.aws.cloudwatch.model.AlarmHistoryItem.wrap(buildAwsValue())
}
object AlarmHistoryItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.AlarmHistoryItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudwatch.model.AlarmHistoryItem =
      zio.aws.cloudwatch.model.AlarmHistoryItem(
        alarmName.map(value => value),
        alarmType.map(value => value),
        timestamp.map(value => value),
        historyItemType.map(value => value),
        historySummary.map(value => value),
        historyData.map(value => value)
      )
    def alarmName: Optional[AlarmName]
    def alarmType: Optional[zio.aws.cloudwatch.model.AlarmType]
    def timestamp: Optional[Timestamp]
    def historyItemType: Optional[zio.aws.cloudwatch.model.HistoryItemType]
    def historySummary: Optional[HistorySummary]
    def historyData: Optional[HistoryData]
    def getAlarmName: ZIO[Any, AwsError, AlarmName] =
      AwsError.unwrapOptionField("alarmName", alarmName)
    def getAlarmType: ZIO[Any, AwsError, zio.aws.cloudwatch.model.AlarmType] =
      AwsError.unwrapOptionField("alarmType", alarmType)
    def getTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("timestamp", timestamp)
    def getHistoryItemType
        : ZIO[Any, AwsError, zio.aws.cloudwatch.model.HistoryItemType] =
      AwsError.unwrapOptionField("historyItemType", historyItemType)
    def getHistorySummary: ZIO[Any, AwsError, HistorySummary] =
      AwsError.unwrapOptionField("historySummary", historySummary)
    def getHistoryData: ZIO[Any, AwsError, HistoryData] =
      AwsError.unwrapOptionField("historyData", historyData)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.AlarmHistoryItem
  ) extends zio.aws.cloudwatch.model.AlarmHistoryItem.ReadOnly {
    override val alarmName: Optional[AlarmName] = zio.aws.core.internal
      .optionalFromNullable(impl.alarmName())
      .map(value => zio.aws.cloudwatch.model.primitives.AlarmName(value))
    override val alarmType: Optional[zio.aws.cloudwatch.model.AlarmType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.alarmType())
        .map(value => zio.aws.cloudwatch.model.AlarmType.wrap(value))
    override val timestamp: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.timestamp())
      .map(value => zio.aws.cloudwatch.model.primitives.Timestamp(value))
    override val historyItemType
        : Optional[zio.aws.cloudwatch.model.HistoryItemType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.historyItemType())
        .map(value => zio.aws.cloudwatch.model.HistoryItemType.wrap(value))
    override val historySummary: Optional[HistorySummary] =
      zio.aws.core.internal
        .optionalFromNullable(impl.historySummary())
        .map(value => zio.aws.cloudwatch.model.primitives.HistorySummary(value))
    override val historyData: Optional[HistoryData] = zio.aws.core.internal
      .optionalFromNullable(impl.historyData())
      .map(value => zio.aws.cloudwatch.model.primitives.HistoryData(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.AlarmHistoryItem
  ): zio.aws.cloudwatch.model.AlarmHistoryItem.ReadOnly = new Wrapper(impl)
}
