package zio.aws.cloudwatch.model
import scala.jdk.CollectionConverters._
sealed trait AnomalyDetectorStateValue {
  def unwrap: software.amazon.awssdk.services.cloudwatch.model.AnomalyDetectorStateValue
}
object AnomalyDetectorStateValue {
  def wrap(
      value: software.amazon.awssdk.services.cloudwatch.model.AnomalyDetectorStateValue
  ): zio.aws.cloudwatch.model.AnomalyDetectorStateValue = value match {
    case software.amazon.awssdk.services.cloudwatch.model.AnomalyDetectorStateValue.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudwatch.model.AnomalyDetectorStateValue.PENDING_TRAINING =>
      val r = PENDING_TRAINING
      r
    case software.amazon.awssdk.services.cloudwatch.model.AnomalyDetectorStateValue.TRAINED_INSUFFICIENT_DATA =>
      val r = TRAINED_INSUFFICIENT_DATA
      r
    case software.amazon.awssdk.services.cloudwatch.model.AnomalyDetectorStateValue.TRAINED =>
      val r = TRAINED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudwatch.model.AnomalyDetectorStateValue {
    override def unwrap
        : software.amazon.awssdk.services.cloudwatch.model.AnomalyDetectorStateValue =
      software.amazon.awssdk.services.cloudwatch.model.AnomalyDetectorStateValue.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING_TRAINING
      extends zio.aws.cloudwatch.model.AnomalyDetectorStateValue {
    override def unwrap
        : software.amazon.awssdk.services.cloudwatch.model.AnomalyDetectorStateValue =
      software.amazon.awssdk.services.cloudwatch.model.AnomalyDetectorStateValue.PENDING_TRAINING
  }
  case object TRAINED_INSUFFICIENT_DATA
      extends zio.aws.cloudwatch.model.AnomalyDetectorStateValue {
    override def unwrap
        : software.amazon.awssdk.services.cloudwatch.model.AnomalyDetectorStateValue =
      software.amazon.awssdk.services.cloudwatch.model.AnomalyDetectorStateValue.TRAINED_INSUFFICIENT_DATA
  }
  case object TRAINED
      extends zio.aws.cloudwatch.model.AnomalyDetectorStateValue {
    override def unwrap
        : software.amazon.awssdk.services.cloudwatch.model.AnomalyDetectorStateValue =
      software.amazon.awssdk.services.cloudwatch.model.AnomalyDetectorStateValue.TRAINED
  }
}
