package zio.aws.cloudwatch.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.cloudwatch.model.primitives.{
  ActionsSuppressedReason,
  StateReason,
  ActionsEnabled,
  AlarmName,
  Timestamp,
  AlarmArn,
  SuppressorPeriod,
  AlarmDescription,
  AlarmRule,
  StateReasonData,
  ResourceName
}
import scala.jdk.CollectionConverters._
final case class CompositeAlarm(
    actionsEnabled: Optional[ActionsEnabled] = Optional.Absent,
    alarmActions: Optional[Iterable[ResourceName]] = Optional.Absent,
    alarmArn: Optional[AlarmArn] = Optional.Absent,
    alarmConfigurationUpdatedTimestamp: Optional[Timestamp] = Optional.Absent,
    alarmDescription: Optional[AlarmDescription] = Optional.Absent,
    alarmName: Optional[AlarmName] = Optional.Absent,
    alarmRule: Optional[AlarmRule] = Optional.Absent,
    insufficientDataActions: Optional[Iterable[ResourceName]] = Optional.Absent,
    okActions: Optional[Iterable[ResourceName]] = Optional.Absent,
    stateReason: Optional[StateReason] = Optional.Absent,
    stateReasonData: Optional[StateReasonData] = Optional.Absent,
    stateUpdatedTimestamp: Optional[Timestamp] = Optional.Absent,
    stateValue: Optional[zio.aws.cloudwatch.model.StateValue] = Optional.Absent,
    stateTransitionedTimestamp: Optional[Timestamp] = Optional.Absent,
    actionsSuppressedBy: Optional[
      zio.aws.cloudwatch.model.ActionsSuppressedBy
    ] = Optional.Absent,
    actionsSuppressedReason: Optional[ActionsSuppressedReason] =
      Optional.Absent,
    actionsSuppressor: Optional[AlarmArn] = Optional.Absent,
    actionsSuppressorWaitPeriod: Optional[SuppressorPeriod] = Optional.Absent,
    actionsSuppressorExtensionPeriod: Optional[SuppressorPeriod] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.CompositeAlarm = {
    import CompositeAlarm.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.CompositeAlarm
      .builder()
      .optionallyWith(
        actionsEnabled.map(value =>
          ActionsEnabled.unwrap(value): java.lang.Boolean
        )
      )(_.actionsEnabled)
      .optionallyWith(
        alarmActions.map(value =>
          value.map { item =>
            ResourceName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.alarmActions)
      .optionallyWith(
        alarmArn.map(value => AlarmArn.unwrap(value): java.lang.String)
      )(_.alarmArn)
      .optionallyWith(
        alarmConfigurationUpdatedTimestamp.map(value =>
          Timestamp.unwrap(value): Instant
        )
      )(_.alarmConfigurationUpdatedTimestamp)
      .optionallyWith(
        alarmDescription.map(value =>
          AlarmDescription.unwrap(value): java.lang.String
        )
      )(_.alarmDescription)
      .optionallyWith(
        alarmName.map(value => AlarmName.unwrap(value): java.lang.String)
      )(_.alarmName)
      .optionallyWith(
        alarmRule.map(value => AlarmRule.unwrap(value): java.lang.String)
      )(_.alarmRule)
      .optionallyWith(
        insufficientDataActions.map(value =>
          value.map { item =>
            ResourceName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.insufficientDataActions)
      .optionallyWith(
        okActions.map(value =>
          value.map { item =>
            ResourceName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.okActions)
      .optionallyWith(
        stateReason.map(value => StateReason.unwrap(value): java.lang.String)
      )(_.stateReason)
      .optionallyWith(
        stateReasonData.map(value =>
          StateReasonData.unwrap(value): java.lang.String
        )
      )(_.stateReasonData)
      .optionallyWith(
        stateUpdatedTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.stateUpdatedTimestamp)
      .optionallyWith(stateValue.map(value => value.unwrap))(_.stateValue)
      .optionallyWith(
        stateTransitionedTimestamp.map(value =>
          Timestamp.unwrap(value): Instant
        )
      )(_.stateTransitionedTimestamp)
      .optionallyWith(actionsSuppressedBy.map(value => value.unwrap))(
        _.actionsSuppressedBy
      )
      .optionallyWith(
        actionsSuppressedReason.map(value =>
          ActionsSuppressedReason.unwrap(value): java.lang.String
        )
      )(_.actionsSuppressedReason)
      .optionallyWith(
        actionsSuppressor.map(value => AlarmArn.unwrap(value): java.lang.String)
      )(_.actionsSuppressor)
      .optionallyWith(
        actionsSuppressorWaitPeriod.map(value =>
          SuppressorPeriod.unwrap(value): Integer
        )
      )(_.actionsSuppressorWaitPeriod)
      .optionallyWith(
        actionsSuppressorExtensionPeriod.map(value =>
          SuppressorPeriod.unwrap(value): Integer
        )
      )(_.actionsSuppressorExtensionPeriod)
      .build()
  }
  def asReadOnly: zio.aws.cloudwatch.model.CompositeAlarm.ReadOnly =
    zio.aws.cloudwatch.model.CompositeAlarm.wrap(buildAwsValue())
}
object CompositeAlarm {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.CompositeAlarm
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudwatch.model.CompositeAlarm =
      zio.aws.cloudwatch.model.CompositeAlarm(
        actionsEnabled.map(value => value),
        alarmActions.map(value => value),
        alarmArn.map(value => value),
        alarmConfigurationUpdatedTimestamp.map(value => value),
        alarmDescription.map(value => value),
        alarmName.map(value => value),
        alarmRule.map(value => value),
        insufficientDataActions.map(value => value),
        okActions.map(value => value),
        stateReason.map(value => value),
        stateReasonData.map(value => value),
        stateUpdatedTimestamp.map(value => value),
        stateValue.map(value => value),
        stateTransitionedTimestamp.map(value => value),
        actionsSuppressedBy.map(value => value),
        actionsSuppressedReason.map(value => value),
        actionsSuppressor.map(value => value),
        actionsSuppressorWaitPeriod.map(value => value),
        actionsSuppressorExtensionPeriod.map(value => value)
      )
    def actionsEnabled: Optional[ActionsEnabled]
    def alarmActions: Optional[List[ResourceName]]
    def alarmArn: Optional[AlarmArn]
    def alarmConfigurationUpdatedTimestamp: Optional[Timestamp]
    def alarmDescription: Optional[AlarmDescription]
    def alarmName: Optional[AlarmName]
    def alarmRule: Optional[AlarmRule]
    def insufficientDataActions: Optional[List[ResourceName]]
    def okActions: Optional[List[ResourceName]]
    def stateReason: Optional[StateReason]
    def stateReasonData: Optional[StateReasonData]
    def stateUpdatedTimestamp: Optional[Timestamp]
    def stateValue: Optional[zio.aws.cloudwatch.model.StateValue]
    def stateTransitionedTimestamp: Optional[Timestamp]
    def actionsSuppressedBy
        : Optional[zio.aws.cloudwatch.model.ActionsSuppressedBy]
    def actionsSuppressedReason: Optional[ActionsSuppressedReason]
    def actionsSuppressor: Optional[AlarmArn]
    def actionsSuppressorWaitPeriod: Optional[SuppressorPeriod]
    def actionsSuppressorExtensionPeriod: Optional[SuppressorPeriod]
    def getActionsEnabled: ZIO[Any, AwsError, ActionsEnabled] =
      AwsError.unwrapOptionField("actionsEnabled", actionsEnabled)
    def getAlarmActions: ZIO[Any, AwsError, List[ResourceName]] =
      AwsError.unwrapOptionField("alarmActions", alarmActions)
    def getAlarmArn: ZIO[Any, AwsError, AlarmArn] =
      AwsError.unwrapOptionField("alarmArn", alarmArn)
    def getAlarmConfigurationUpdatedTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField(
        "alarmConfigurationUpdatedTimestamp",
        alarmConfigurationUpdatedTimestamp
      )
    def getAlarmDescription: ZIO[Any, AwsError, AlarmDescription] =
      AwsError.unwrapOptionField("alarmDescription", alarmDescription)
    def getAlarmName: ZIO[Any, AwsError, AlarmName] =
      AwsError.unwrapOptionField("alarmName", alarmName)
    def getAlarmRule: ZIO[Any, AwsError, AlarmRule] =
      AwsError.unwrapOptionField("alarmRule", alarmRule)
    def getInsufficientDataActions: ZIO[Any, AwsError, List[ResourceName]] =
      AwsError.unwrapOptionField(
        "insufficientDataActions",
        insufficientDataActions
      )
    def getOkActions: ZIO[Any, AwsError, List[ResourceName]] =
      AwsError.unwrapOptionField("okActions", okActions)
    def getStateReason: ZIO[Any, AwsError, StateReason] =
      AwsError.unwrapOptionField("stateReason", stateReason)
    def getStateReasonData: ZIO[Any, AwsError, StateReasonData] =
      AwsError.unwrapOptionField("stateReasonData", stateReasonData)
    def getStateUpdatedTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("stateUpdatedTimestamp", stateUpdatedTimestamp)
    def getStateValue: ZIO[Any, AwsError, zio.aws.cloudwatch.model.StateValue] =
      AwsError.unwrapOptionField("stateValue", stateValue)
    def getStateTransitionedTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField(
        "stateTransitionedTimestamp",
        stateTransitionedTimestamp
      )
    def getActionsSuppressedBy
        : ZIO[Any, AwsError, zio.aws.cloudwatch.model.ActionsSuppressedBy] =
      AwsError.unwrapOptionField("actionsSuppressedBy", actionsSuppressedBy)
    def getActionsSuppressedReason
        : ZIO[Any, AwsError, ActionsSuppressedReason] = AwsError
      .unwrapOptionField("actionsSuppressedReason", actionsSuppressedReason)
    def getActionsSuppressor: ZIO[Any, AwsError, AlarmArn] =
      AwsError.unwrapOptionField("actionsSuppressor", actionsSuppressor)
    def getActionsSuppressorWaitPeriod: ZIO[Any, AwsError, SuppressorPeriod] =
      AwsError.unwrapOptionField(
        "actionsSuppressorWaitPeriod",
        actionsSuppressorWaitPeriod
      )
    def getActionsSuppressorExtensionPeriod
        : ZIO[Any, AwsError, SuppressorPeriod] = AwsError.unwrapOptionField(
      "actionsSuppressorExtensionPeriod",
      actionsSuppressorExtensionPeriod
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.CompositeAlarm
  ) extends zio.aws.cloudwatch.model.CompositeAlarm.ReadOnly {
    override val actionsEnabled: Optional[ActionsEnabled] =
      zio.aws.core.internal
        .optionalFromNullable(impl.actionsEnabled())
        .map(value => zio.aws.cloudwatch.model.primitives.ActionsEnabled(value))
    override val alarmActions: Optional[List[ResourceName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.alarmActions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudwatch.model.primitives.ResourceName(item)
          }.toList
        )
    override val alarmArn: Optional[AlarmArn] = zio.aws.core.internal
      .optionalFromNullable(impl.alarmArn())
      .map(value => zio.aws.cloudwatch.model.primitives.AlarmArn(value))
    override val alarmConfigurationUpdatedTimestamp: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.alarmConfigurationUpdatedTimestamp())
        .map(value => zio.aws.cloudwatch.model.primitives.Timestamp(value))
    override val alarmDescription: Optional[AlarmDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.alarmDescription())
        .map(value =>
          zio.aws.cloudwatch.model.primitives.AlarmDescription(value)
        )
    override val alarmName: Optional[AlarmName] = zio.aws.core.internal
      .optionalFromNullable(impl.alarmName())
      .map(value => zio.aws.cloudwatch.model.primitives.AlarmName(value))
    override val alarmRule: Optional[AlarmRule] = zio.aws.core.internal
      .optionalFromNullable(impl.alarmRule())
      .map(value => zio.aws.cloudwatch.model.primitives.AlarmRule(value))
    override val insufficientDataActions: Optional[List[ResourceName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.insufficientDataActions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudwatch.model.primitives.ResourceName(item)
          }.toList
        )
    override val okActions: Optional[List[ResourceName]] = zio.aws.core.internal
      .optionalFromNullable(impl.okActions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudwatch.model.primitives.ResourceName(item)
        }.toList
      )
    override val stateReason: Optional[StateReason] = zio.aws.core.internal
      .optionalFromNullable(impl.stateReason())
      .map(value => zio.aws.cloudwatch.model.primitives.StateReason(value))
    override val stateReasonData: Optional[StateReasonData] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stateReasonData())
        .map(value =>
          zio.aws.cloudwatch.model.primitives.StateReasonData(value)
        )
    override val stateUpdatedTimestamp: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stateUpdatedTimestamp())
        .map(value => zio.aws.cloudwatch.model.primitives.Timestamp(value))
    override val stateValue: Optional[zio.aws.cloudwatch.model.StateValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stateValue())
        .map(value => zio.aws.cloudwatch.model.StateValue.wrap(value))
    override val stateTransitionedTimestamp: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stateTransitionedTimestamp())
        .map(value => zio.aws.cloudwatch.model.primitives.Timestamp(value))
    override val actionsSuppressedBy
        : Optional[zio.aws.cloudwatch.model.ActionsSuppressedBy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.actionsSuppressedBy())
        .map(value => zio.aws.cloudwatch.model.ActionsSuppressedBy.wrap(value))
    override val actionsSuppressedReason: Optional[ActionsSuppressedReason] =
      zio.aws.core.internal
        .optionalFromNullable(impl.actionsSuppressedReason())
        .map(value =>
          zio.aws.cloudwatch.model.primitives.ActionsSuppressedReason(value)
        )
    override val actionsSuppressor: Optional[AlarmArn] = zio.aws.core.internal
      .optionalFromNullable(impl.actionsSuppressor())
      .map(value => zio.aws.cloudwatch.model.primitives.AlarmArn(value))
    override val actionsSuppressorWaitPeriod: Optional[SuppressorPeriod] =
      zio.aws.core.internal
        .optionalFromNullable(impl.actionsSuppressorWaitPeriod())
        .map(value =>
          zio.aws.cloudwatch.model.primitives.SuppressorPeriod(value)
        )
    override val actionsSuppressorExtensionPeriod: Optional[SuppressorPeriod] =
      zio.aws.core.internal
        .optionalFromNullable(impl.actionsSuppressorExtensionPeriod())
        .map(value =>
          zio.aws.cloudwatch.model.primitives.SuppressorPeriod(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.CompositeAlarm
  ): zio.aws.cloudwatch.model.CompositeAlarm.ReadOnly = new Wrapper(impl)
}
