package zio.aws.cloudwatch.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.cloudwatch.model.primitives.{
  Size,
  LastModified,
  DashboardArn,
  DashboardName
}
import scala.jdk.CollectionConverters._
final case class DashboardEntry(
    dashboardName: Optional[DashboardName] = Optional.Absent,
    dashboardArn: Optional[DashboardArn] = Optional.Absent,
    lastModified: Optional[LastModified] = Optional.Absent,
    size: Optional[Size] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.DashboardEntry = {
    import DashboardEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.DashboardEntry
      .builder()
      .optionallyWith(
        dashboardName.map(value =>
          DashboardName.unwrap(value): java.lang.String
        )
      )(_.dashboardName)
      .optionallyWith(
        dashboardArn.map(value => DashboardArn.unwrap(value): java.lang.String)
      )(_.dashboardArn)
      .optionallyWith(
        lastModified.map(value => LastModified.unwrap(value): Instant)
      )(_.lastModified)
      .optionallyWith(size.map(value => Size.unwrap(value): java.lang.Long))(
        _.size
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudwatch.model.DashboardEntry.ReadOnly =
    zio.aws.cloudwatch.model.DashboardEntry.wrap(buildAwsValue())
}
object DashboardEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.DashboardEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudwatch.model.DashboardEntry =
      zio.aws.cloudwatch.model.DashboardEntry(
        dashboardName.map(value => value),
        dashboardArn.map(value => value),
        lastModified.map(value => value),
        size.map(value => value)
      )
    def dashboardName: Optional[DashboardName]
    def dashboardArn: Optional[DashboardArn]
    def lastModified: Optional[LastModified]
    def size: Optional[Size]
    def getDashboardName: ZIO[Any, AwsError, DashboardName] =
      AwsError.unwrapOptionField("dashboardName", dashboardName)
    def getDashboardArn: ZIO[Any, AwsError, DashboardArn] =
      AwsError.unwrapOptionField("dashboardArn", dashboardArn)
    def getLastModified: ZIO[Any, AwsError, LastModified] =
      AwsError.unwrapOptionField("lastModified", lastModified)
    def getSize: ZIO[Any, AwsError, Size] =
      AwsError.unwrapOptionField("size", size)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.DashboardEntry
  ) extends zio.aws.cloudwatch.model.DashboardEntry.ReadOnly {
    override val dashboardName: Optional[DashboardName] = zio.aws.core.internal
      .optionalFromNullable(impl.dashboardName())
      .map(value => zio.aws.cloudwatch.model.primitives.DashboardName(value))
    override val dashboardArn: Optional[DashboardArn] = zio.aws.core.internal
      .optionalFromNullable(impl.dashboardArn())
      .map(value => zio.aws.cloudwatch.model.primitives.DashboardArn(value))
    override val lastModified: Optional[LastModified] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModified())
      .map(value => zio.aws.cloudwatch.model.primitives.LastModified(value))
    override val size: Optional[Size] = zio.aws.core.internal
      .optionalFromNullable(impl.size())
      .map(value => zio.aws.cloudwatch.model.primitives.Size(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.DashboardEntry
  ): zio.aws.cloudwatch.model.DashboardEntry.ReadOnly = new Wrapper(impl)
}
