package zio.aws.cloudwatch.model
import zio.aws.cloudwatch.model.primitives.{Message, DataPath}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DashboardValidationMessage(
    dataPath: Optional[DataPath] = Optional.Absent,
    message: Optional[Message] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.DashboardValidationMessage = {
    import DashboardValidationMessage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.DashboardValidationMessage
      .builder()
      .optionallyWith(
        dataPath.map(value => DataPath.unwrap(value): java.lang.String)
      )(_.dataPath)
      .optionallyWith(
        message.map(value => Message.unwrap(value): java.lang.String)
      )(_.message)
      .build()
  }
  def asReadOnly: zio.aws.cloudwatch.model.DashboardValidationMessage.ReadOnly =
    zio.aws.cloudwatch.model.DashboardValidationMessage.wrap(buildAwsValue())
}
object DashboardValidationMessage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.DashboardValidationMessage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudwatch.model.DashboardValidationMessage =
      zio.aws.cloudwatch.model.DashboardValidationMessage(
        dataPath.map(value => value),
        message.map(value => value)
      )
    def dataPath: Optional[DataPath]
    def message: Optional[Message]
    def getDataPath: ZIO[Any, AwsError, DataPath] =
      AwsError.unwrapOptionField("dataPath", dataPath)
    def getMessage: ZIO[Any, AwsError, Message] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.DashboardValidationMessage
  ) extends zio.aws.cloudwatch.model.DashboardValidationMessage.ReadOnly {
    override val dataPath: Optional[DataPath] = zio.aws.core.internal
      .optionalFromNullable(impl.dataPath())
      .map(value => zio.aws.cloudwatch.model.primitives.DataPath(value))
    override val message: Optional[Message] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => zio.aws.cloudwatch.model.primitives.Message(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.DashboardValidationMessage
  ): zio.aws.cloudwatch.model.DashboardValidationMessage.ReadOnly = new Wrapper(
    impl
  )
}
