package zio.aws.cloudwatch.model
import zio.aws.cloudwatch.model.primitives.AlarmName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteAlarmsRequest(alarmNames: Iterable[AlarmName]) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.DeleteAlarmsRequest = {
    import DeleteAlarmsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.DeleteAlarmsRequest
      .builder()
      .alarmNames(alarmNames.map { item =>
        AlarmName.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.cloudwatch.model.DeleteAlarmsRequest.ReadOnly =
    zio.aws.cloudwatch.model.DeleteAlarmsRequest.wrap(buildAwsValue())
}
object DeleteAlarmsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.DeleteAlarmsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudwatch.model.DeleteAlarmsRequest =
      zio.aws.cloudwatch.model.DeleteAlarmsRequest(alarmNames)
    def alarmNames: List[AlarmName]
    def getAlarmNames: ZIO[Any, Nothing, List[AlarmName]] =
      ZIO.succeed(alarmNames)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.DeleteAlarmsRequest
  ) extends zio.aws.cloudwatch.model.DeleteAlarmsRequest.ReadOnly {
    override val alarmNames: List[AlarmName] = impl
      .alarmNames()
      .asScala
      .map { item =>
        zio.aws.cloudwatch.model.primitives.AlarmName(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.DeleteAlarmsRequest
  ): zio.aws.cloudwatch.model.DeleteAlarmsRequest.ReadOnly = new Wrapper(impl)
}
