package zio.aws.cloudwatch.model
import zio.aws.cloudwatch.model.primitives.DashboardName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteDashboardsRequest(
    dashboardNames: Iterable[DashboardName]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.DeleteDashboardsRequest = {
    import DeleteDashboardsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.DeleteDashboardsRequest
      .builder()
      .dashboardNames(dashboardNames.map { item =>
        DashboardName.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.cloudwatch.model.DeleteDashboardsRequest.ReadOnly =
    zio.aws.cloudwatch.model.DeleteDashboardsRequest.wrap(buildAwsValue())
}
object DeleteDashboardsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.DeleteDashboardsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudwatch.model.DeleteDashboardsRequest =
      zio.aws.cloudwatch.model.DeleteDashboardsRequest(dashboardNames)
    def dashboardNames: List[DashboardName]
    def getDashboardNames: ZIO[Any, Nothing, List[DashboardName]] =
      ZIO.succeed(dashboardNames)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.DeleteDashboardsRequest
  ) extends zio.aws.cloudwatch.model.DeleteDashboardsRequest.ReadOnly {
    override val dashboardNames: List[DashboardName] = impl
      .dashboardNames()
      .asScala
      .map { item =>
        zio.aws.cloudwatch.model.primitives.DashboardName(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.DeleteDashboardsRequest
  ): zio.aws.cloudwatch.model.DeleteDashboardsRequest.ReadOnly = new Wrapper(
    impl
  )
}
