package zio.aws.cloudwatch.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.cloudwatch.model.primitives.{
  NextToken,
  MaxRecords,
  Timestamp,
  AlarmName
}
import scala.jdk.CollectionConverters._
final case class DescribeAlarmHistoryRequest(
    alarmName: Optional[AlarmName] = Optional.Absent,
    alarmTypes: Optional[Iterable[zio.aws.cloudwatch.model.AlarmType]] =
      Optional.Absent,
    historyItemType: Optional[zio.aws.cloudwatch.model.HistoryItemType] =
      Optional.Absent,
    startDate: Optional[Timestamp] = Optional.Absent,
    endDate: Optional[Timestamp] = Optional.Absent,
    maxRecords: Optional[MaxRecords] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    scanBy: Optional[zio.aws.cloudwatch.model.ScanBy] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmHistoryRequest = {
    import DescribeAlarmHistoryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmHistoryRequest
      .builder()
      .optionallyWith(
        alarmName.map(value => AlarmName.unwrap(value): java.lang.String)
      )(_.alarmName)
      .optionallyWith(
        alarmTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.alarmTypesWithStrings)
      .optionallyWith(historyItemType.map(value => value.unwrap))(
        _.historyItemType
      )
      .optionallyWith(startDate.map(value => Timestamp.unwrap(value): Instant))(
        _.startDate
      )
      .optionallyWith(endDate.map(value => Timestamp.unwrap(value): Instant))(
        _.endDate
      )
      .optionallyWith(
        maxRecords.map(value => MaxRecords.unwrap(value): Integer)
      )(_.maxRecords)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(scanBy.map(value => value.unwrap))(_.scanBy)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudwatch.model.DescribeAlarmHistoryRequest.ReadOnly =
    zio.aws.cloudwatch.model.DescribeAlarmHistoryRequest.wrap(buildAwsValue())
}
object DescribeAlarmHistoryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmHistoryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudwatch.model.DescribeAlarmHistoryRequest =
      zio.aws.cloudwatch.model.DescribeAlarmHistoryRequest(
        alarmName.map(value => value),
        alarmTypes.map(value => value),
        historyItemType.map(value => value),
        startDate.map(value => value),
        endDate.map(value => value),
        maxRecords.map(value => value),
        nextToken.map(value => value),
        scanBy.map(value => value)
      )
    def alarmName: Optional[AlarmName]
    def alarmTypes: Optional[List[zio.aws.cloudwatch.model.AlarmType]]
    def historyItemType: Optional[zio.aws.cloudwatch.model.HistoryItemType]
    def startDate: Optional[Timestamp]
    def endDate: Optional[Timestamp]
    def maxRecords: Optional[MaxRecords]
    def nextToken: Optional[NextToken]
    def scanBy: Optional[zio.aws.cloudwatch.model.ScanBy]
    def getAlarmName: ZIO[Any, AwsError, AlarmName] =
      AwsError.unwrapOptionField("alarmName", alarmName)
    def getAlarmTypes
        : ZIO[Any, AwsError, List[zio.aws.cloudwatch.model.AlarmType]] =
      AwsError.unwrapOptionField("alarmTypes", alarmTypes)
    def getHistoryItemType
        : ZIO[Any, AwsError, zio.aws.cloudwatch.model.HistoryItemType] =
      AwsError.unwrapOptionField("historyItemType", historyItemType)
    def getStartDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startDate", startDate)
    def getEndDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endDate", endDate)
    def getMaxRecords: ZIO[Any, AwsError, MaxRecords] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getScanBy: ZIO[Any, AwsError, zio.aws.cloudwatch.model.ScanBy] =
      AwsError.unwrapOptionField("scanBy", scanBy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmHistoryRequest
  ) extends zio.aws.cloudwatch.model.DescribeAlarmHistoryRequest.ReadOnly {
    override val alarmName: Optional[AlarmName] = zio.aws.core.internal
      .optionalFromNullable(impl.alarmName())
      .map(value => zio.aws.cloudwatch.model.primitives.AlarmName(value))
    override val alarmTypes
        : Optional[List[zio.aws.cloudwatch.model.AlarmType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.alarmTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudwatch.model.AlarmType.wrap(item)
          }.toList
        )
    override val historyItemType
        : Optional[zio.aws.cloudwatch.model.HistoryItemType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.historyItemType())
        .map(value => zio.aws.cloudwatch.model.HistoryItemType.wrap(value))
    override val startDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.startDate())
      .map(value => zio.aws.cloudwatch.model.primitives.Timestamp(value))
    override val endDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.endDate())
      .map(value => zio.aws.cloudwatch.model.primitives.Timestamp(value))
    override val maxRecords: Optional[MaxRecords] = zio.aws.core.internal
      .optionalFromNullable(impl.maxRecords())
      .map(value => zio.aws.cloudwatch.model.primitives.MaxRecords(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.cloudwatch.model.primitives.NextToken(value))
    override val scanBy: Optional[zio.aws.cloudwatch.model.ScanBy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scanBy())
        .map(value => zio.aws.cloudwatch.model.ScanBy.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmHistoryRequest
  ): zio.aws.cloudwatch.model.DescribeAlarmHistoryRequest.ReadOnly =
    new Wrapper(impl)
}
