package zio.aws.cloudwatch.model
import zio.aws.cloudwatch.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeAlarmHistoryResponse(
    alarmHistoryItems: Optional[
      Iterable[zio.aws.cloudwatch.model.AlarmHistoryItem]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmHistoryResponse = {
    import DescribeAlarmHistoryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmHistoryResponse
      .builder()
      .optionallyWith(
        alarmHistoryItems.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.alarmHistoryItems)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudwatch.model.DescribeAlarmHistoryResponse.ReadOnly =
    zio.aws.cloudwatch.model.DescribeAlarmHistoryResponse.wrap(buildAwsValue())
}
object DescribeAlarmHistoryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmHistoryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudwatch.model.DescribeAlarmHistoryResponse =
      zio.aws.cloudwatch.model.DescribeAlarmHistoryResponse(
        alarmHistoryItems.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def alarmHistoryItems
        : Optional[List[zio.aws.cloudwatch.model.AlarmHistoryItem.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getAlarmHistoryItems: ZIO[Any, AwsError, List[
      zio.aws.cloudwatch.model.AlarmHistoryItem.ReadOnly
    ]] = AwsError.unwrapOptionField("alarmHistoryItems", alarmHistoryItems)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmHistoryResponse
  ) extends zio.aws.cloudwatch.model.DescribeAlarmHistoryResponse.ReadOnly {
    override val alarmHistoryItems
        : Optional[List[zio.aws.cloudwatch.model.AlarmHistoryItem.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.alarmHistoryItems())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudwatch.model.AlarmHistoryItem.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.cloudwatch.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmHistoryResponse
  ): zio.aws.cloudwatch.model.DescribeAlarmHistoryResponse.ReadOnly =
    new Wrapper(impl)
}
