package zio.aws.cloudwatch.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.cloudwatch.model.primitives.{
  Period,
  ExtendedStatistic,
  Namespace,
  MetricName
}
import scala.jdk.CollectionConverters._
final case class DescribeAlarmsForMetricRequest(
    metricName: MetricName,
    namespace: Namespace,
    statistic: Optional[zio.aws.cloudwatch.model.Statistic] = Optional.Absent,
    extendedStatistic: Optional[ExtendedStatistic] = Optional.Absent,
    dimensions: Optional[Iterable[zio.aws.cloudwatch.model.Dimension]] =
      Optional.Absent,
    period: Optional[Period] = Optional.Absent,
    unit: Optional[zio.aws.cloudwatch.model.StandardUnit] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsForMetricRequest = {
    import DescribeAlarmsForMetricRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsForMetricRequest
      .builder()
      .metricName(MetricName.unwrap(metricName): java.lang.String)
      .namespace(Namespace.unwrap(namespace): java.lang.String)
      .optionallyWith(statistic.map(value => value.unwrap))(_.statistic)
      .optionallyWith(
        extendedStatistic.map(value =>
          ExtendedStatistic.unwrap(value): java.lang.String
        )
      )(_.extendedStatistic)
      .optionallyWith(
        dimensions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dimensions)
      .optionallyWith(period.map(value => Period.unwrap(value): Integer))(
        _.period
      )
      .optionallyWith(unit.map(value => value.unwrap))(_.unit)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudwatch.model.DescribeAlarmsForMetricRequest.ReadOnly =
    zio.aws.cloudwatch.model.DescribeAlarmsForMetricRequest
      .wrap(buildAwsValue())
}
object DescribeAlarmsForMetricRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsForMetricRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudwatch.model.DescribeAlarmsForMetricRequest =
      zio.aws.cloudwatch.model.DescribeAlarmsForMetricRequest(
        metricName,
        namespace,
        statistic.map(value => value),
        extendedStatistic.map(value => value),
        dimensions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        period.map(value => value),
        unit.map(value => value)
      )
    def metricName: MetricName
    def namespace: Namespace
    def statistic: Optional[zio.aws.cloudwatch.model.Statistic]
    def extendedStatistic: Optional[ExtendedStatistic]
    def dimensions: Optional[List[zio.aws.cloudwatch.model.Dimension.ReadOnly]]
    def period: Optional[Period]
    def unit: Optional[zio.aws.cloudwatch.model.StandardUnit]
    def getMetricName: ZIO[Any, Nothing, MetricName] = ZIO.succeed(metricName)
    def getNamespace: ZIO[Any, Nothing, Namespace] = ZIO.succeed(namespace)
    def getStatistic: ZIO[Any, AwsError, zio.aws.cloudwatch.model.Statistic] =
      AwsError.unwrapOptionField("statistic", statistic)
    def getExtendedStatistic: ZIO[Any, AwsError, ExtendedStatistic] =
      AwsError.unwrapOptionField("extendedStatistic", extendedStatistic)
    def getDimensions: ZIO[Any, AwsError, List[
      zio.aws.cloudwatch.model.Dimension.ReadOnly
    ]] = AwsError.unwrapOptionField("dimensions", dimensions)
    def getPeriod: ZIO[Any, AwsError, Period] =
      AwsError.unwrapOptionField("period", period)
    def getUnit: ZIO[Any, AwsError, zio.aws.cloudwatch.model.StandardUnit] =
      AwsError.unwrapOptionField("unit", unit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsForMetricRequest
  ) extends zio.aws.cloudwatch.model.DescribeAlarmsForMetricRequest.ReadOnly {
    override val metricName: MetricName =
      zio.aws.cloudwatch.model.primitives.MetricName(impl.metricName())
    override val namespace: Namespace =
      zio.aws.cloudwatch.model.primitives.Namespace(impl.namespace())
    override val statistic: Optional[zio.aws.cloudwatch.model.Statistic] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statistic())
        .map(value => zio.aws.cloudwatch.model.Statistic.wrap(value))
    override val extendedStatistic: Optional[ExtendedStatistic] =
      zio.aws.core.internal
        .optionalFromNullable(impl.extendedStatistic())
        .map(value =>
          zio.aws.cloudwatch.model.primitives.ExtendedStatistic(value)
        )
    override val dimensions
        : Optional[List[zio.aws.cloudwatch.model.Dimension.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dimensions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudwatch.model.Dimension.wrap(item)
          }.toList
        )
    override val period: Optional[Period] = zio.aws.core.internal
      .optionalFromNullable(impl.period())
      .map(value => zio.aws.cloudwatch.model.primitives.Period(value))
    override val unit: Optional[zio.aws.cloudwatch.model.StandardUnit] =
      zio.aws.core.internal
        .optionalFromNullable(impl.unit())
        .map(value => zio.aws.cloudwatch.model.StandardUnit.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsForMetricRequest
  ): zio.aws.cloudwatch.model.DescribeAlarmsForMetricRequest.ReadOnly =
    new Wrapper(impl)
}
