package zio.aws.cloudwatch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeAlarmsForMetricResponse(
    metricAlarms: Optional[Iterable[zio.aws.cloudwatch.model.MetricAlarm]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsForMetricResponse = {
    import DescribeAlarmsForMetricResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsForMetricResponse
      .builder()
      .optionallyWith(
        metricAlarms.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.metricAlarms)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudwatch.model.DescribeAlarmsForMetricResponse.ReadOnly =
    zio.aws.cloudwatch.model.DescribeAlarmsForMetricResponse
      .wrap(buildAwsValue())
}
object DescribeAlarmsForMetricResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsForMetricResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudwatch.model.DescribeAlarmsForMetricResponse =
      zio.aws.cloudwatch.model.DescribeAlarmsForMetricResponse(
        metricAlarms.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def metricAlarms
        : Optional[List[zio.aws.cloudwatch.model.MetricAlarm.ReadOnly]]
    def getMetricAlarms: ZIO[Any, AwsError, List[
      zio.aws.cloudwatch.model.MetricAlarm.ReadOnly
    ]] = AwsError.unwrapOptionField("metricAlarms", metricAlarms)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsForMetricResponse
  ) extends zio.aws.cloudwatch.model.DescribeAlarmsForMetricResponse.ReadOnly {
    override val metricAlarms
        : Optional[List[zio.aws.cloudwatch.model.MetricAlarm.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metricAlarms())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudwatch.model.MetricAlarm.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsForMetricResponse
  ): zio.aws.cloudwatch.model.DescribeAlarmsForMetricResponse.ReadOnly =
    new Wrapper(impl)
}
