package zio.aws.cloudwatch.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.cloudwatch.model.primitives.{
  MetricName,
  Namespace,
  MaxReturnedResultsCount,
  NextToken
}
import scala.jdk.CollectionConverters._
final case class DescribeAnomalyDetectorsRequest(
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxReturnedResultsCount] = Optional.Absent,
    namespace: Optional[Namespace] = Optional.Absent,
    metricName: Optional[MetricName] = Optional.Absent,
    dimensions: Optional[Iterable[zio.aws.cloudwatch.model.Dimension]] =
      Optional.Absent,
    anomalyDetectorTypes: Optional[
      Iterable[zio.aws.cloudwatch.model.AnomalyDetectorType]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.DescribeAnomalyDetectorsRequest = {
    import DescribeAnomalyDetectorsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.DescribeAnomalyDetectorsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxReturnedResultsCount.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        namespace.map(value => Namespace.unwrap(value): java.lang.String)
      )(_.namespace)
      .optionallyWith(
        metricName.map(value => MetricName.unwrap(value): java.lang.String)
      )(_.metricName)
      .optionallyWith(
        dimensions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dimensions)
      .optionallyWith(
        anomalyDetectorTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.anomalyDetectorTypesWithStrings)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudwatch.model.DescribeAnomalyDetectorsRequest.ReadOnly =
    zio.aws.cloudwatch.model.DescribeAnomalyDetectorsRequest
      .wrap(buildAwsValue())
}
object DescribeAnomalyDetectorsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.DescribeAnomalyDetectorsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudwatch.model.DescribeAnomalyDetectorsRequest =
      zio.aws.cloudwatch.model.DescribeAnomalyDetectorsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        namespace.map(value => value),
        metricName.map(value => value),
        dimensions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        anomalyDetectorTypes.map(value => value)
      )
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxReturnedResultsCount]
    def namespace: Optional[Namespace]
    def metricName: Optional[MetricName]
    def dimensions: Optional[List[zio.aws.cloudwatch.model.Dimension.ReadOnly]]
    def anomalyDetectorTypes
        : Optional[List[zio.aws.cloudwatch.model.AnomalyDetectorType]]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxReturnedResultsCount] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNamespace: ZIO[Any, AwsError, Namespace] =
      AwsError.unwrapOptionField("namespace", namespace)
    def getMetricName: ZIO[Any, AwsError, MetricName] =
      AwsError.unwrapOptionField("metricName", metricName)
    def getDimensions: ZIO[Any, AwsError, List[
      zio.aws.cloudwatch.model.Dimension.ReadOnly
    ]] = AwsError.unwrapOptionField("dimensions", dimensions)
    def getAnomalyDetectorTypes: ZIO[Any, AwsError, List[
      zio.aws.cloudwatch.model.AnomalyDetectorType
    ]] =
      AwsError.unwrapOptionField("anomalyDetectorTypes", anomalyDetectorTypes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.DescribeAnomalyDetectorsRequest
  ) extends zio.aws.cloudwatch.model.DescribeAnomalyDetectorsRequest.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.cloudwatch.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxReturnedResultsCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.cloudwatch.model.primitives.MaxReturnedResultsCount(value)
        )
    override val namespace: Optional[Namespace] = zio.aws.core.internal
      .optionalFromNullable(impl.namespace())
      .map(value => zio.aws.cloudwatch.model.primitives.Namespace(value))
    override val metricName: Optional[MetricName] = zio.aws.core.internal
      .optionalFromNullable(impl.metricName())
      .map(value => zio.aws.cloudwatch.model.primitives.MetricName(value))
    override val dimensions
        : Optional[List[zio.aws.cloudwatch.model.Dimension.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dimensions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudwatch.model.Dimension.wrap(item)
          }.toList
        )
    override val anomalyDetectorTypes
        : Optional[List[zio.aws.cloudwatch.model.AnomalyDetectorType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.anomalyDetectorTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudwatch.model.AnomalyDetectorType.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.DescribeAnomalyDetectorsRequest
  ): zio.aws.cloudwatch.model.DescribeAnomalyDetectorsRequest.ReadOnly =
    new Wrapper(impl)
}
