package zio.aws.cloudwatch.model
import zio.aws.cloudwatch.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeAnomalyDetectorsResponse(
    anomalyDetectors: Optional[
      Iterable[zio.aws.cloudwatch.model.AnomalyDetector]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.DescribeAnomalyDetectorsResponse = {
    import DescribeAnomalyDetectorsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.DescribeAnomalyDetectorsResponse
      .builder()
      .optionallyWith(
        anomalyDetectors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.anomalyDetectors)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudwatch.model.DescribeAnomalyDetectorsResponse.ReadOnly =
    zio.aws.cloudwatch.model.DescribeAnomalyDetectorsResponse
      .wrap(buildAwsValue())
}
object DescribeAnomalyDetectorsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.DescribeAnomalyDetectorsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudwatch.model.DescribeAnomalyDetectorsResponse =
      zio.aws.cloudwatch.model.DescribeAnomalyDetectorsResponse(
        anomalyDetectors.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def anomalyDetectors
        : Optional[List[zio.aws.cloudwatch.model.AnomalyDetector.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getAnomalyDetectors: ZIO[Any, AwsError, List[
      zio.aws.cloudwatch.model.AnomalyDetector.ReadOnly
    ]] = AwsError.unwrapOptionField("anomalyDetectors", anomalyDetectors)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.DescribeAnomalyDetectorsResponse
  ) extends zio.aws.cloudwatch.model.DescribeAnomalyDetectorsResponse.ReadOnly {
    override val anomalyDetectors
        : Optional[List[zio.aws.cloudwatch.model.AnomalyDetector.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.anomalyDetectors())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudwatch.model.AnomalyDetector.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.cloudwatch.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.DescribeAnomalyDetectorsResponse
  ): zio.aws.cloudwatch.model.DescribeAnomalyDetectorsResponse.ReadOnly =
    new Wrapper(impl)
}
