package zio.aws.cloudwatch.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.cloudwatch.model.primitives.{InsightRuleMaxResults, NextToken}
import scala.jdk.CollectionConverters._
final case class DescribeInsightRulesRequest(
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[InsightRuleMaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.DescribeInsightRulesRequest = {
    import DescribeInsightRulesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.DescribeInsightRulesRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => InsightRuleMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudwatch.model.DescribeInsightRulesRequest.ReadOnly =
    zio.aws.cloudwatch.model.DescribeInsightRulesRequest.wrap(buildAwsValue())
}
object DescribeInsightRulesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.DescribeInsightRulesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudwatch.model.DescribeInsightRulesRequest =
      zio.aws.cloudwatch.model.DescribeInsightRulesRequest(
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def nextToken: Optional[NextToken]
    def maxResults: Optional[InsightRuleMaxResults]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, InsightRuleMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.DescribeInsightRulesRequest
  ) extends zio.aws.cloudwatch.model.DescribeInsightRulesRequest.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.cloudwatch.model.primitives.NextToken(value))
    override val maxResults: Optional[InsightRuleMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.cloudwatch.model.primitives.InsightRuleMaxResults(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.DescribeInsightRulesRequest
  ): zio.aws.cloudwatch.model.DescribeInsightRulesRequest.ReadOnly =
    new Wrapper(impl)
}
