package zio.aws.cloudwatch.model
import zio.aws.cloudwatch.model.primitives.{DimensionValue, DimensionName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DimensionFilter(
    name: DimensionName,
    value: Optional[DimensionValue] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.DimensionFilter = {
    import DimensionFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.DimensionFilter
      .builder()
      .name(DimensionName.unwrap(name): java.lang.String)
      .optionallyWith(
        value.map(value => DimensionValue.unwrap(value): java.lang.String)
      )(_.value)
      .build()
  }
  def asReadOnly: zio.aws.cloudwatch.model.DimensionFilter.ReadOnly =
    zio.aws.cloudwatch.model.DimensionFilter.wrap(buildAwsValue())
}
object DimensionFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.DimensionFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudwatch.model.DimensionFilter =
      zio.aws.cloudwatch.model.DimensionFilter(name, value.map(value => value))
    def name: DimensionName
    def value: Optional[DimensionValue]
    def getName: ZIO[Any, Nothing, DimensionName] = ZIO.succeed(name)
    def getValue: ZIO[Any, AwsError, DimensionValue] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.DimensionFilter
  ) extends zio.aws.cloudwatch.model.DimensionFilter.ReadOnly {
    override val name: DimensionName =
      zio.aws.cloudwatch.model.primitives.DimensionName(impl.name())
    override val value: Optional[DimensionValue] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => zio.aws.cloudwatch.model.primitives.DimensionValue(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.DimensionFilter
  ): zio.aws.cloudwatch.model.DimensionFilter.ReadOnly = new Wrapper(impl)
}
