package zio.aws.cloudwatch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DisableInsightRulesResponse(
    failures: Optional[Iterable[zio.aws.cloudwatch.model.PartialFailure]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.DisableInsightRulesResponse = {
    import DisableInsightRulesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.DisableInsightRulesResponse
      .builder()
      .optionallyWith(
        failures.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.failures)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudwatch.model.DisableInsightRulesResponse.ReadOnly =
    zio.aws.cloudwatch.model.DisableInsightRulesResponse.wrap(buildAwsValue())
}
object DisableInsightRulesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.DisableInsightRulesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudwatch.model.DisableInsightRulesResponse =
      zio.aws.cloudwatch.model.DisableInsightRulesResponse(
        failures.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def failures
        : Optional[List[zio.aws.cloudwatch.model.PartialFailure.ReadOnly]]
    def getFailures: ZIO[Any, AwsError, List[
      zio.aws.cloudwatch.model.PartialFailure.ReadOnly
    ]] = AwsError.unwrapOptionField("failures", failures)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.DisableInsightRulesResponse
  ) extends zio.aws.cloudwatch.model.DisableInsightRulesResponse.ReadOnly {
    override val failures
        : Optional[List[zio.aws.cloudwatch.model.PartialFailure.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failures())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudwatch.model.PartialFailure.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.DisableInsightRulesResponse
  ): zio.aws.cloudwatch.model.DisableInsightRulesResponse.ReadOnly =
    new Wrapper(impl)
}
