package zio.aws.cloudwatch.model
import zio.aws.cloudwatch.model.primitives.AlarmName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class EnableAlarmActionsRequest(alarmNames: Iterable[AlarmName]) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.EnableAlarmActionsRequest = {
    import EnableAlarmActionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.EnableAlarmActionsRequest
      .builder()
      .alarmNames(alarmNames.map { item =>
        AlarmName.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.cloudwatch.model.EnableAlarmActionsRequest.ReadOnly =
    zio.aws.cloudwatch.model.EnableAlarmActionsRequest.wrap(buildAwsValue())
}
object EnableAlarmActionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.EnableAlarmActionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudwatch.model.EnableAlarmActionsRequest =
      zio.aws.cloudwatch.model.EnableAlarmActionsRequest(alarmNames)
    def alarmNames: List[AlarmName]
    def getAlarmNames: ZIO[Any, Nothing, List[AlarmName]] =
      ZIO.succeed(alarmNames)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.EnableAlarmActionsRequest
  ) extends zio.aws.cloudwatch.model.EnableAlarmActionsRequest.ReadOnly {
    override val alarmNames: List[AlarmName] = impl
      .alarmNames()
      .asScala
      .map { item =>
        zio.aws.cloudwatch.model.primitives.AlarmName(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.EnableAlarmActionsRequest
  ): zio.aws.cloudwatch.model.EnableAlarmActionsRequest.ReadOnly = new Wrapper(
    impl
  )
}
