package zio.aws.cloudwatch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EnableInsightRulesResponse(
    failures: Optional[Iterable[zio.aws.cloudwatch.model.PartialFailure]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.EnableInsightRulesResponse = {
    import EnableInsightRulesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.EnableInsightRulesResponse
      .builder()
      .optionallyWith(
        failures.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.failures)
      .build()
  }
  def asReadOnly: zio.aws.cloudwatch.model.EnableInsightRulesResponse.ReadOnly =
    zio.aws.cloudwatch.model.EnableInsightRulesResponse.wrap(buildAwsValue())
}
object EnableInsightRulesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.EnableInsightRulesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudwatch.model.EnableInsightRulesResponse =
      zio.aws.cloudwatch.model.EnableInsightRulesResponse(
        failures.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def failures
        : Optional[List[zio.aws.cloudwatch.model.PartialFailure.ReadOnly]]
    def getFailures: ZIO[Any, AwsError, List[
      zio.aws.cloudwatch.model.PartialFailure.ReadOnly
    ]] = AwsError.unwrapOptionField("failures", failures)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.EnableInsightRulesResponse
  ) extends zio.aws.cloudwatch.model.EnableInsightRulesResponse.ReadOnly {
    override val failures
        : Optional[List[zio.aws.cloudwatch.model.PartialFailure.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failures())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudwatch.model.PartialFailure.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.EnableInsightRulesResponse
  ): zio.aws.cloudwatch.model.EnableInsightRulesResponse.ReadOnly = new Wrapper(
    impl
  )
}
