package zio.aws.cloudwatch.model
import zio.aws.cloudwatch.model.primitives.{
  DashboardName,
  DashboardBody,
  DashboardArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetDashboardResponse(
    dashboardArn: Optional[DashboardArn] = Optional.Absent,
    dashboardBody: Optional[DashboardBody] = Optional.Absent,
    dashboardName: Optional[DashboardName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.GetDashboardResponse = {
    import GetDashboardResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.GetDashboardResponse
      .builder()
      .optionallyWith(
        dashboardArn.map(value => DashboardArn.unwrap(value): java.lang.String)
      )(_.dashboardArn)
      .optionallyWith(
        dashboardBody.map(value =>
          DashboardBody.unwrap(value): java.lang.String
        )
      )(_.dashboardBody)
      .optionallyWith(
        dashboardName.map(value =>
          DashboardName.unwrap(value): java.lang.String
        )
      )(_.dashboardName)
      .build()
  }
  def asReadOnly: zio.aws.cloudwatch.model.GetDashboardResponse.ReadOnly =
    zio.aws.cloudwatch.model.GetDashboardResponse.wrap(buildAwsValue())
}
object GetDashboardResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.GetDashboardResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudwatch.model.GetDashboardResponse =
      zio.aws.cloudwatch.model.GetDashboardResponse(
        dashboardArn.map(value => value),
        dashboardBody.map(value => value),
        dashboardName.map(value => value)
      )
    def dashboardArn: Optional[DashboardArn]
    def dashboardBody: Optional[DashboardBody]
    def dashboardName: Optional[DashboardName]
    def getDashboardArn: ZIO[Any, AwsError, DashboardArn] =
      AwsError.unwrapOptionField("dashboardArn", dashboardArn)
    def getDashboardBody: ZIO[Any, AwsError, DashboardBody] =
      AwsError.unwrapOptionField("dashboardBody", dashboardBody)
    def getDashboardName: ZIO[Any, AwsError, DashboardName] =
      AwsError.unwrapOptionField("dashboardName", dashboardName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.GetDashboardResponse
  ) extends zio.aws.cloudwatch.model.GetDashboardResponse.ReadOnly {
    override val dashboardArn: Optional[DashboardArn] = zio.aws.core.internal
      .optionalFromNullable(impl.dashboardArn())
      .map(value => zio.aws.cloudwatch.model.primitives.DashboardArn(value))
    override val dashboardBody: Optional[DashboardBody] = zio.aws.core.internal
      .optionalFromNullable(impl.dashboardBody())
      .map(value => zio.aws.cloudwatch.model.primitives.DashboardBody(value))
    override val dashboardName: Optional[DashboardName] = zio.aws.core.internal
      .optionalFromNullable(impl.dashboardName())
      .map(value => zio.aws.cloudwatch.model.primitives.DashboardName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.GetDashboardResponse
  ): zio.aws.cloudwatch.model.GetDashboardResponse.ReadOnly = new Wrapper(impl)
}
