package zio.aws.cloudwatch.model
import zio.aws.cloudwatch.model.primitives.{
  InsightRuleUnboundLong,
  InsightRuleUnboundDouble,
  InsightRuleAggregationStatistic,
  InsightRuleContributorKeyLabel
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetInsightRuleReportResponse(
    keyLabels: Optional[Iterable[InsightRuleContributorKeyLabel]] =
      Optional.Absent,
    aggregationStatistic: Optional[InsightRuleAggregationStatistic] =
      Optional.Absent,
    aggregateValue: Optional[InsightRuleUnboundDouble] = Optional.Absent,
    approximateUniqueCount: Optional[InsightRuleUnboundLong] = Optional.Absent,
    contributors: Optional[
      Iterable[zio.aws.cloudwatch.model.InsightRuleContributor]
    ] = Optional.Absent,
    metricDatapoints: Optional[
      Iterable[zio.aws.cloudwatch.model.InsightRuleMetricDatapoint]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.GetInsightRuleReportResponse = {
    import GetInsightRuleReportResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.GetInsightRuleReportResponse
      .builder()
      .optionallyWith(
        keyLabels.map(value =>
          value.map { item =>
            InsightRuleContributorKeyLabel.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.keyLabels)
      .optionallyWith(
        aggregationStatistic.map(value =>
          InsightRuleAggregationStatistic.unwrap(value): java.lang.String
        )
      )(_.aggregationStatistic)
      .optionallyWith(
        aggregateValue.map(value =>
          InsightRuleUnboundDouble.unwrap(value): java.lang.Double
        )
      )(_.aggregateValue)
      .optionallyWith(
        approximateUniqueCount.map(value =>
          InsightRuleUnboundLong.unwrap(value): java.lang.Long
        )
      )(_.approximateUniqueCount)
      .optionallyWith(
        contributors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.contributors)
      .optionallyWith(
        metricDatapoints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.metricDatapoints)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudwatch.model.GetInsightRuleReportResponse.ReadOnly =
    zio.aws.cloudwatch.model.GetInsightRuleReportResponse.wrap(buildAwsValue())
}
object GetInsightRuleReportResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.GetInsightRuleReportResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudwatch.model.GetInsightRuleReportResponse =
      zio.aws.cloudwatch.model.GetInsightRuleReportResponse(
        keyLabels.map(value => value),
        aggregationStatistic.map(value => value),
        aggregateValue.map(value => value),
        approximateUniqueCount.map(value => value),
        contributors.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        metricDatapoints.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def keyLabels: Optional[List[InsightRuleContributorKeyLabel]]
    def aggregationStatistic: Optional[InsightRuleAggregationStatistic]
    def aggregateValue: Optional[InsightRuleUnboundDouble]
    def approximateUniqueCount: Optional[InsightRuleUnboundLong]
    def contributors: Optional[
      List[zio.aws.cloudwatch.model.InsightRuleContributor.ReadOnly]
    ]
    def metricDatapoints: Optional[
      List[zio.aws.cloudwatch.model.InsightRuleMetricDatapoint.ReadOnly]
    ]
    def getKeyLabels: ZIO[Any, AwsError, List[InsightRuleContributorKeyLabel]] =
      AwsError.unwrapOptionField("keyLabels", keyLabels)
    def getAggregationStatistic
        : ZIO[Any, AwsError, InsightRuleAggregationStatistic] =
      AwsError.unwrapOptionField("aggregationStatistic", aggregationStatistic)
    def getAggregateValue: ZIO[Any, AwsError, InsightRuleUnboundDouble] =
      AwsError.unwrapOptionField("aggregateValue", aggregateValue)
    def getApproximateUniqueCount: ZIO[Any, AwsError, InsightRuleUnboundLong] =
      AwsError.unwrapOptionField(
        "approximateUniqueCount",
        approximateUniqueCount
      )
    def getContributors: ZIO[Any, AwsError, List[
      zio.aws.cloudwatch.model.InsightRuleContributor.ReadOnly
    ]] = AwsError.unwrapOptionField("contributors", contributors)
    def getMetricDatapoints: ZIO[Any, AwsError, List[
      zio.aws.cloudwatch.model.InsightRuleMetricDatapoint.ReadOnly
    ]] = AwsError.unwrapOptionField("metricDatapoints", metricDatapoints)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.GetInsightRuleReportResponse
  ) extends zio.aws.cloudwatch.model.GetInsightRuleReportResponse.ReadOnly {
    override val keyLabels: Optional[List[InsightRuleContributorKeyLabel]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.keyLabels())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudwatch.model.primitives
              .InsightRuleContributorKeyLabel(item)
          }.toList
        )
    override val aggregationStatistic
        : Optional[InsightRuleAggregationStatistic] = zio.aws.core.internal
      .optionalFromNullable(impl.aggregationStatistic())
      .map(value =>
        zio.aws.cloudwatch.model.primitives
          .InsightRuleAggregationStatistic(value)
      )
    override val aggregateValue: Optional[InsightRuleUnboundDouble] =
      zio.aws.core.internal
        .optionalFromNullable(impl.aggregateValue())
        .map(value =>
          zio.aws.cloudwatch.model.primitives.InsightRuleUnboundDouble(value)
        )
    override val approximateUniqueCount: Optional[InsightRuleUnboundLong] =
      zio.aws.core.internal
        .optionalFromNullable(impl.approximateUniqueCount())
        .map(value =>
          zio.aws.cloudwatch.model.primitives.InsightRuleUnboundLong(value)
        )
    override val contributors: Optional[
      List[zio.aws.cloudwatch.model.InsightRuleContributor.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.contributors())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudwatch.model.InsightRuleContributor.wrap(item)
        }.toList
      )
    override val metricDatapoints: Optional[
      List[zio.aws.cloudwatch.model.InsightRuleMetricDatapoint.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.metricDatapoints())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudwatch.model.InsightRuleMetricDatapoint.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.GetInsightRuleReportResponse
  ): zio.aws.cloudwatch.model.GetInsightRuleReportResponse.ReadOnly =
    new Wrapper(impl)
}
