package zio.aws.cloudwatch.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.cloudwatch.model.primitives.{
  GetMetricDataMaxDatapoints,
  NextToken,
  Timestamp
}
import scala.jdk.CollectionConverters._
final case class GetMetricDataRequest(
    metricDataQueries: Iterable[zio.aws.cloudwatch.model.MetricDataQuery],
    startTime: Timestamp,
    endTime: Timestamp,
    nextToken: Optional[NextToken] = Optional.Absent,
    scanBy: Optional[zio.aws.cloudwatch.model.ScanBy] = Optional.Absent,
    maxDatapoints: Optional[GetMetricDataMaxDatapoints] = Optional.Absent,
    labelOptions: Optional[zio.aws.cloudwatch.model.LabelOptions] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.GetMetricDataRequest = {
    import GetMetricDataRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.GetMetricDataRequest
      .builder()
      .metricDataQueries(metricDataQueries.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .startTime(Timestamp.unwrap(startTime): Instant)
      .endTime(Timestamp.unwrap(endTime): Instant)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(scanBy.map(value => value.unwrap))(_.scanBy)
      .optionallyWith(
        maxDatapoints.map(value =>
          GetMetricDataMaxDatapoints.unwrap(value): Integer
        )
      )(_.maxDatapoints)
      .optionallyWith(labelOptions.map(value => value.buildAwsValue()))(
        _.labelOptions
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudwatch.model.GetMetricDataRequest.ReadOnly =
    zio.aws.cloudwatch.model.GetMetricDataRequest.wrap(buildAwsValue())
}
object GetMetricDataRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.GetMetricDataRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudwatch.model.GetMetricDataRequest =
      zio.aws.cloudwatch.model.GetMetricDataRequest(
        metricDataQueries.map { item =>
          item.asEditable
        },
        startTime,
        endTime,
        nextToken.map(value => value),
        scanBy.map(value => value),
        maxDatapoints.map(value => value),
        labelOptions.map(value => value.asEditable)
      )
    def metricDataQueries
        : List[zio.aws.cloudwatch.model.MetricDataQuery.ReadOnly]
    def startTime: Timestamp
    def endTime: Timestamp
    def nextToken: Optional[NextToken]
    def scanBy: Optional[zio.aws.cloudwatch.model.ScanBy]
    def maxDatapoints: Optional[GetMetricDataMaxDatapoints]
    def labelOptions: Optional[zio.aws.cloudwatch.model.LabelOptions.ReadOnly]
    def getMetricDataQueries: ZIO[Any, Nothing, List[
      zio.aws.cloudwatch.model.MetricDataQuery.ReadOnly
    ]] = ZIO.succeed(metricDataQueries)
    def getStartTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(startTime)
    def getEndTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(endTime)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getScanBy: ZIO[Any, AwsError, zio.aws.cloudwatch.model.ScanBy] =
      AwsError.unwrapOptionField("scanBy", scanBy)
    def getMaxDatapoints: ZIO[Any, AwsError, GetMetricDataMaxDatapoints] =
      AwsError.unwrapOptionField("maxDatapoints", maxDatapoints)
    def getLabelOptions
        : ZIO[Any, AwsError, zio.aws.cloudwatch.model.LabelOptions.ReadOnly] =
      AwsError.unwrapOptionField("labelOptions", labelOptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.GetMetricDataRequest
  ) extends zio.aws.cloudwatch.model.GetMetricDataRequest.ReadOnly {
    override val metricDataQueries
        : List[zio.aws.cloudwatch.model.MetricDataQuery.ReadOnly] = impl
      .metricDataQueries()
      .asScala
      .map { item =>
        zio.aws.cloudwatch.model.MetricDataQuery.wrap(item)
      }
      .toList
    override val startTime: Timestamp =
      zio.aws.cloudwatch.model.primitives.Timestamp(impl.startTime())
    override val endTime: Timestamp =
      zio.aws.cloudwatch.model.primitives.Timestamp(impl.endTime())
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.cloudwatch.model.primitives.NextToken(value))
    override val scanBy: Optional[zio.aws.cloudwatch.model.ScanBy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scanBy())
        .map(value => zio.aws.cloudwatch.model.ScanBy.wrap(value))
    override val maxDatapoints: Optional[GetMetricDataMaxDatapoints] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxDatapoints())
        .map(value =>
          zio.aws.cloudwatch.model.primitives.GetMetricDataMaxDatapoints(value)
        )
    override val labelOptions
        : Optional[zio.aws.cloudwatch.model.LabelOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.labelOptions())
        .map(value => zio.aws.cloudwatch.model.LabelOptions.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.GetMetricDataRequest
  ): zio.aws.cloudwatch.model.GetMetricDataRequest.ReadOnly = new Wrapper(impl)
}
