package zio.aws.cloudwatch.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.cloudwatch.model.primitives.{
  MetricName,
  ExtendedStatistic,
  Namespace,
  Timestamp,
  Period
}
import scala.jdk.CollectionConverters._
final case class GetMetricStatisticsRequest(
    namespace: Namespace,
    metricName: MetricName,
    dimensions: Optional[Iterable[zio.aws.cloudwatch.model.Dimension]] =
      Optional.Absent,
    startTime: Timestamp,
    endTime: Timestamp,
    period: Period,
    statistics: Optional[Iterable[zio.aws.cloudwatch.model.Statistic]] =
      Optional.Absent,
    extendedStatistics: Optional[Iterable[ExtendedStatistic]] = Optional.Absent,
    unit: Optional[zio.aws.cloudwatch.model.StandardUnit] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.GetMetricStatisticsRequest = {
    import GetMetricStatisticsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.GetMetricStatisticsRequest
      .builder()
      .namespace(Namespace.unwrap(namespace): java.lang.String)
      .metricName(MetricName.unwrap(metricName): java.lang.String)
      .optionallyWith(
        dimensions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dimensions)
      .startTime(Timestamp.unwrap(startTime): Instant)
      .endTime(Timestamp.unwrap(endTime): Instant)
      .period(Period.unwrap(period): Integer)
      .optionallyWith(
        statistics.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.statisticsWithStrings)
      .optionallyWith(
        extendedStatistics.map(value =>
          value.map { item =>
            ExtendedStatistic.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.extendedStatistics)
      .optionallyWith(unit.map(value => value.unwrap))(_.unit)
      .build()
  }
  def asReadOnly: zio.aws.cloudwatch.model.GetMetricStatisticsRequest.ReadOnly =
    zio.aws.cloudwatch.model.GetMetricStatisticsRequest.wrap(buildAwsValue())
}
object GetMetricStatisticsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.GetMetricStatisticsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudwatch.model.GetMetricStatisticsRequest =
      zio.aws.cloudwatch.model.GetMetricStatisticsRequest(
        namespace,
        metricName,
        dimensions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        startTime,
        endTime,
        period,
        statistics.map(value => value),
        extendedStatistics.map(value => value),
        unit.map(value => value)
      )
    def namespace: Namespace
    def metricName: MetricName
    def dimensions: Optional[List[zio.aws.cloudwatch.model.Dimension.ReadOnly]]
    def startTime: Timestamp
    def endTime: Timestamp
    def period: Period
    def statistics: Optional[List[zio.aws.cloudwatch.model.Statistic]]
    def extendedStatistics: Optional[List[ExtendedStatistic]]
    def unit: Optional[zio.aws.cloudwatch.model.StandardUnit]
    def getNamespace: ZIO[Any, Nothing, Namespace] = ZIO.succeed(namespace)
    def getMetricName: ZIO[Any, Nothing, MetricName] = ZIO.succeed(metricName)
    def getDimensions: ZIO[Any, AwsError, List[
      zio.aws.cloudwatch.model.Dimension.ReadOnly
    ]] = AwsError.unwrapOptionField("dimensions", dimensions)
    def getStartTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(startTime)
    def getEndTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(endTime)
    def getPeriod: ZIO[Any, Nothing, Period] = ZIO.succeed(period)
    def getStatistics
        : ZIO[Any, AwsError, List[zio.aws.cloudwatch.model.Statistic]] =
      AwsError.unwrapOptionField("statistics", statistics)
    def getExtendedStatistics: ZIO[Any, AwsError, List[ExtendedStatistic]] =
      AwsError.unwrapOptionField("extendedStatistics", extendedStatistics)
    def getUnit: ZIO[Any, AwsError, zio.aws.cloudwatch.model.StandardUnit] =
      AwsError.unwrapOptionField("unit", unit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.GetMetricStatisticsRequest
  ) extends zio.aws.cloudwatch.model.GetMetricStatisticsRequest.ReadOnly {
    override val namespace: Namespace =
      zio.aws.cloudwatch.model.primitives.Namespace(impl.namespace())
    override val metricName: MetricName =
      zio.aws.cloudwatch.model.primitives.MetricName(impl.metricName())
    override val dimensions
        : Optional[List[zio.aws.cloudwatch.model.Dimension.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dimensions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudwatch.model.Dimension.wrap(item)
          }.toList
        )
    override val startTime: Timestamp =
      zio.aws.cloudwatch.model.primitives.Timestamp(impl.startTime())
    override val endTime: Timestamp =
      zio.aws.cloudwatch.model.primitives.Timestamp(impl.endTime())
    override val period: Period =
      zio.aws.cloudwatch.model.primitives.Period(impl.period())
    override val statistics
        : Optional[List[zio.aws.cloudwatch.model.Statistic]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statistics())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudwatch.model.Statistic.wrap(item)
          }.toList
        )
    override val extendedStatistics: Optional[List[ExtendedStatistic]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.extendedStatistics())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudwatch.model.primitives.ExtendedStatistic(item)
          }.toList
        )
    override val unit: Optional[zio.aws.cloudwatch.model.StandardUnit] =
      zio.aws.core.internal
        .optionalFromNullable(impl.unit())
        .map(value => zio.aws.cloudwatch.model.StandardUnit.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.GetMetricStatisticsRequest
  ): zio.aws.cloudwatch.model.GetMetricStatisticsRequest.ReadOnly = new Wrapper(
    impl
  )
}
