package zio.aws.cloudwatch.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.cloudwatch.model.primitives.{
  Timestamp,
  MetricStreamState,
  MetricStreamName,
  AmazonResourceName,
  IncludeLinkedAccountsMetrics
}
import scala.jdk.CollectionConverters._
final case class GetMetricStreamResponse(
    arn: Optional[AmazonResourceName] = Optional.Absent,
    name: Optional[MetricStreamName] = Optional.Absent,
    includeFilters: Optional[
      Iterable[zio.aws.cloudwatch.model.MetricStreamFilter]
    ] = Optional.Absent,
    excludeFilters: Optional[
      Iterable[zio.aws.cloudwatch.model.MetricStreamFilter]
    ] = Optional.Absent,
    firehoseArn: Optional[AmazonResourceName] = Optional.Absent,
    roleArn: Optional[AmazonResourceName] = Optional.Absent,
    state: Optional[MetricStreamState] = Optional.Absent,
    creationDate: Optional[Timestamp] = Optional.Absent,
    lastUpdateDate: Optional[Timestamp] = Optional.Absent,
    outputFormat: Optional[zio.aws.cloudwatch.model.MetricStreamOutputFormat] =
      Optional.Absent,
    statisticsConfigurations: Optional[
      Iterable[zio.aws.cloudwatch.model.MetricStreamStatisticsConfiguration]
    ] = Optional.Absent,
    includeLinkedAccountsMetrics: Optional[IncludeLinkedAccountsMetrics] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.GetMetricStreamResponse = {
    import GetMetricStreamResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.GetMetricStreamResponse
      .builder()
      .optionallyWith(
        arn.map(value => AmazonResourceName.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        name.map(value => MetricStreamName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        includeFilters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.includeFilters)
      .optionallyWith(
        excludeFilters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.excludeFilters)
      .optionallyWith(
        firehoseArn.map(value =>
          AmazonResourceName.unwrap(value): java.lang.String
        )
      )(_.firehoseArn)
      .optionallyWith(
        roleArn.map(value => AmazonResourceName.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        state.map(value => MetricStreamState.unwrap(value): java.lang.String)
      )(_.state)
      .optionallyWith(
        creationDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(
        lastUpdateDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdateDate)
      .optionallyWith(outputFormat.map(value => value.unwrap))(_.outputFormat)
      .optionallyWith(
        statisticsConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.statisticsConfigurations)
      .optionallyWith(
        includeLinkedAccountsMetrics.map(value =>
          IncludeLinkedAccountsMetrics.unwrap(value): java.lang.Boolean
        )
      )(_.includeLinkedAccountsMetrics)
      .build()
  }
  def asReadOnly: zio.aws.cloudwatch.model.GetMetricStreamResponse.ReadOnly =
    zio.aws.cloudwatch.model.GetMetricStreamResponse.wrap(buildAwsValue())
}
object GetMetricStreamResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.GetMetricStreamResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudwatch.model.GetMetricStreamResponse =
      zio.aws.cloudwatch.model.GetMetricStreamResponse(
        arn.map(value => value),
        name.map(value => value),
        includeFilters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        excludeFilters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        firehoseArn.map(value => value),
        roleArn.map(value => value),
        state.map(value => value),
        creationDate.map(value => value),
        lastUpdateDate.map(value => value),
        outputFormat.map(value => value),
        statisticsConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        includeLinkedAccountsMetrics.map(value => value)
      )
    def arn: Optional[AmazonResourceName]
    def name: Optional[MetricStreamName]
    def includeFilters
        : Optional[List[zio.aws.cloudwatch.model.MetricStreamFilter.ReadOnly]]
    def excludeFilters
        : Optional[List[zio.aws.cloudwatch.model.MetricStreamFilter.ReadOnly]]
    def firehoseArn: Optional[AmazonResourceName]
    def roleArn: Optional[AmazonResourceName]
    def state: Optional[MetricStreamState]
    def creationDate: Optional[Timestamp]
    def lastUpdateDate: Optional[Timestamp]
    def outputFormat
        : Optional[zio.aws.cloudwatch.model.MetricStreamOutputFormat]
    def statisticsConfigurations: Optional[List[
      zio.aws.cloudwatch.model.MetricStreamStatisticsConfiguration.ReadOnly
    ]]
    def includeLinkedAccountsMetrics: Optional[IncludeLinkedAccountsMetrics]
    def getArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, MetricStreamName] =
      AwsError.unwrapOptionField("name", name)
    def getIncludeFilters: ZIO[Any, AwsError, List[
      zio.aws.cloudwatch.model.MetricStreamFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("includeFilters", includeFilters)
    def getExcludeFilters: ZIO[Any, AwsError, List[
      zio.aws.cloudwatch.model.MetricStreamFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("excludeFilters", excludeFilters)
    def getFirehoseArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("firehoseArn", firehoseArn)
    def getRoleArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getState: ZIO[Any, AwsError, MetricStreamState] =
      AwsError.unwrapOptionField("state", state)
    def getCreationDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getLastUpdateDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdateDate", lastUpdateDate)
    def getOutputFormat: ZIO[
      Any,
      AwsError,
      zio.aws.cloudwatch.model.MetricStreamOutputFormat
    ] = AwsError.unwrapOptionField("outputFormat", outputFormat)
    def getStatisticsConfigurations: ZIO[Any, AwsError, List[
      zio.aws.cloudwatch.model.MetricStreamStatisticsConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "statisticsConfigurations",
      statisticsConfigurations
    )
    def getIncludeLinkedAccountsMetrics
        : ZIO[Any, AwsError, IncludeLinkedAccountsMetrics] =
      AwsError.unwrapOptionField(
        "includeLinkedAccountsMetrics",
        includeLinkedAccountsMetrics
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.GetMetricStreamResponse
  ) extends zio.aws.cloudwatch.model.GetMetricStreamResponse.ReadOnly {
    override val arn: Optional[AmazonResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value =>
        zio.aws.cloudwatch.model.primitives.AmazonResourceName(value)
      )
    override val name: Optional[MetricStreamName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.cloudwatch.model.primitives.MetricStreamName(value))
    override val includeFilters
        : Optional[List[zio.aws.cloudwatch.model.MetricStreamFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.includeFilters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudwatch.model.MetricStreamFilter.wrap(item)
          }.toList
        )
    override val excludeFilters
        : Optional[List[zio.aws.cloudwatch.model.MetricStreamFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.excludeFilters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudwatch.model.MetricStreamFilter.wrap(item)
          }.toList
        )
    override val firehoseArn: Optional[AmazonResourceName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.firehoseArn())
        .map(value =>
          zio.aws.cloudwatch.model.primitives.AmazonResourceName(value)
        )
    override val roleArn: Optional[AmazonResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value =>
        zio.aws.cloudwatch.model.primitives.AmazonResourceName(value)
      )
    override val state: Optional[MetricStreamState] = zio.aws.core.internal
      .optionalFromNullable(impl.state())
      .map(value =>
        zio.aws.cloudwatch.model.primitives.MetricStreamState(value)
      )
    override val creationDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDate())
      .map(value => zio.aws.cloudwatch.model.primitives.Timestamp(value))
    override val lastUpdateDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdateDate())
      .map(value => zio.aws.cloudwatch.model.primitives.Timestamp(value))
    override val outputFormat
        : Optional[zio.aws.cloudwatch.model.MetricStreamOutputFormat] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outputFormat())
        .map(value =>
          zio.aws.cloudwatch.model.MetricStreamOutputFormat.wrap(value)
        )
    override val statisticsConfigurations: Optional[List[
      zio.aws.cloudwatch.model.MetricStreamStatisticsConfiguration.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.statisticsConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudwatch.model.MetricStreamStatisticsConfiguration
            .wrap(item)
        }.toList
      )
    override val includeLinkedAccountsMetrics
        : Optional[IncludeLinkedAccountsMetrics] = zio.aws.core.internal
      .optionalFromNullable(impl.includeLinkedAccountsMetrics())
      .map(value =>
        zio.aws.cloudwatch.model.primitives.IncludeLinkedAccountsMetrics(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.GetMetricStreamResponse
  ): zio.aws.cloudwatch.model.GetMetricStreamResponse.ReadOnly = new Wrapper(
    impl
  )
}
