package zio.aws.cloudwatch.model
import zio.aws.cloudwatch.model.primitives.{InsightRuleUnboundDouble, Timestamp}
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class InsightRuleContributorDatapoint(
    timestamp: Timestamp,
    approximateValue: InsightRuleUnboundDouble
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.InsightRuleContributorDatapoint = {
    import InsightRuleContributorDatapoint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.InsightRuleContributorDatapoint
      .builder()
      .timestamp(Timestamp.unwrap(timestamp): Instant)
      .approximateValue(
        InsightRuleUnboundDouble.unwrap(approximateValue): java.lang.Double
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cloudwatch.model.InsightRuleContributorDatapoint.ReadOnly =
    zio.aws.cloudwatch.model.InsightRuleContributorDatapoint
      .wrap(buildAwsValue())
}
object InsightRuleContributorDatapoint {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.InsightRuleContributorDatapoint
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudwatch.model.InsightRuleContributorDatapoint =
      zio.aws.cloudwatch.model
        .InsightRuleContributorDatapoint(timestamp, approximateValue)
    def timestamp: Timestamp
    def approximateValue: InsightRuleUnboundDouble
    def getTimestamp: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(timestamp)
    def getApproximateValue: ZIO[Any, Nothing, InsightRuleUnboundDouble] =
      ZIO.succeed(approximateValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.InsightRuleContributorDatapoint
  ) extends zio.aws.cloudwatch.model.InsightRuleContributorDatapoint.ReadOnly {
    override val timestamp: Timestamp =
      zio.aws.cloudwatch.model.primitives.Timestamp(impl.timestamp())
    override val approximateValue: InsightRuleUnboundDouble =
      zio.aws.cloudwatch.model.primitives
        .InsightRuleUnboundDouble(impl.approximateValue())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.InsightRuleContributorDatapoint
  ): zio.aws.cloudwatch.model.InsightRuleContributorDatapoint.ReadOnly =
    new Wrapper(impl)
}
