package zio.aws.cloudwatch.model
import zio.aws.cloudwatch.model.primitives.GetMetricDataLabelTimezone
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LabelOptions(
    timezone: Optional[GetMetricDataLabelTimezone] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.LabelOptions = {
    import LabelOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.LabelOptions
      .builder()
      .optionallyWith(
        timezone.map(value =>
          GetMetricDataLabelTimezone.unwrap(value): java.lang.String
        )
      )(_.timezone)
      .build()
  }
  def asReadOnly: zio.aws.cloudwatch.model.LabelOptions.ReadOnly =
    zio.aws.cloudwatch.model.LabelOptions.wrap(buildAwsValue())
}
object LabelOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.LabelOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudwatch.model.LabelOptions =
      zio.aws.cloudwatch.model.LabelOptions(timezone.map(value => value))
    def timezone: Optional[GetMetricDataLabelTimezone]
    def getTimezone: ZIO[Any, AwsError, GetMetricDataLabelTimezone] =
      AwsError.unwrapOptionField("timezone", timezone)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.LabelOptions
  ) extends zio.aws.cloudwatch.model.LabelOptions.ReadOnly {
    override val timezone: Optional[GetMetricDataLabelTimezone] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timezone())
        .map(value =>
          zio.aws.cloudwatch.model.primitives.GetMetricDataLabelTimezone(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.LabelOptions
  ): zio.aws.cloudwatch.model.LabelOptions.ReadOnly = new Wrapper(impl)
}
