package zio.aws.cloudwatch.model
import zio.aws.cloudwatch.model.primitives.{NextToken, DashboardNamePrefix}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListDashboardsRequest(
    dashboardNamePrefix: Optional[DashboardNamePrefix] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.ListDashboardsRequest = {
    import ListDashboardsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.ListDashboardsRequest
      .builder()
      .optionallyWith(
        dashboardNamePrefix.map(value =>
          DashboardNamePrefix.unwrap(value): java.lang.String
        )
      )(_.dashboardNamePrefix)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.cloudwatch.model.ListDashboardsRequest.ReadOnly =
    zio.aws.cloudwatch.model.ListDashboardsRequest.wrap(buildAwsValue())
}
object ListDashboardsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.ListDashboardsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudwatch.model.ListDashboardsRequest =
      zio.aws.cloudwatch.model.ListDashboardsRequest(
        dashboardNamePrefix.map(value => value),
        nextToken.map(value => value)
      )
    def dashboardNamePrefix: Optional[DashboardNamePrefix]
    def nextToken: Optional[NextToken]
    def getDashboardNamePrefix: ZIO[Any, AwsError, DashboardNamePrefix] =
      AwsError.unwrapOptionField("dashboardNamePrefix", dashboardNamePrefix)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.ListDashboardsRequest
  ) extends zio.aws.cloudwatch.model.ListDashboardsRequest.ReadOnly {
    override val dashboardNamePrefix: Optional[DashboardNamePrefix] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dashboardNamePrefix())
        .map(value =>
          zio.aws.cloudwatch.model.primitives.DashboardNamePrefix(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.cloudwatch.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.ListDashboardsRequest
  ): zio.aws.cloudwatch.model.ListDashboardsRequest.ReadOnly = new Wrapper(impl)
}
